/************************************************************************/
/*	ணࠬ . 						*/
/*	. ᠭ.							*/
/*	Copyright 1993, InfoScope.					*/
/************************************************************************/

#include <ctype.h>
#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <time.h>

#include "kalah.h"

NODE rootPos;                   /*  			*/
				/*  ᫥ ᤥ 室            */

	/* ६, ᯮ㥬  ॡ.		*/
NODE bestMove;                  /* , 㤠 findMove ᮢ 	*/
                                /*   樨 rootPos.            */
int      cL,			/* 騩 ஢ ॡࠥ 㧫.	*/
	 maxLevel=MAXLEVEL;	/* . ஢ ॡࠥ 㧫.	*/
NODE     wStack[MAXLEVEL+1];    /* ⥪  室 ॢ          */
NODE     curPos;		/*  ६ - . findMove.	*/

                /* ६  ࠭ 室 .          */
NODE gameA[100]=                /* ᨢ  ࠭ 室 ப .  */
                {-1,-1};        /* , ᯮ㥬  뢮 .  */
NODE gameB[100];                /* ᨢ  ࠭ 室 ப .  */
int gameLength=0;               /* ⢮ 室  .             */

		/* ६  "䥩" ࠬ஢	*/
int wEnt;			/* 㦭    ENTER ᫥	*/
				/* ᮮ饭 "" - . askProgram	*/
whoToMove aPlayer;		/* ப  - Program/Human.		*/
turnToPlay firstToPlay;		/*  室 ப   ?		*/

int x[14],y[14];                 /* न   ࠭.  	*/

		/* ﭨ  㭪.			*/
#define stepX           9
#define stepY		2
		/* न   㣫 "᪨".	*/
#define cornX		17
#define cornY		15

void main (void)
{
   whoToMove  movesNow;
   int endGame = 0,flag;

   askTunes();
   initialize();

   rootPos.move[0] = firstToPlay == aToPlay ? 7 : 0;
			/* "।ࢮ" ﭨ (. Aplays):		*/
			/* ⢮ਬ,  㫥 室 㦥 ᤥ -	*/
			/* ப B, ᫨  室  ,	*/
                        /* ப , ᫨  室  .	*/
   movesNow = firstToPlay == aToPlay ? aPlayer : Program;
   flag = firstToPlay == aToPlay ? 0 : 1;
   while(!endGame)
   {
      endGame = getMove(movesNow);
      movesNow = movesNow == aPlayer ? Program : aPlayer;
      if(!Aplays(rootPos))
         gameA[gameLength] = rootPos;
      else
         gameB[gameLength] = rootPos;
      if(flag) flag = !(++gameLength); else flag = 1;
   }
   drawScreen();		/* 뢥 ⥫ .	*/
   saveGame();			/* 襬   䠩 'lastgame.klh'.	*/
   sayBye();
}/*main*/

void askTunes(void)
{
   char c;

   clrscr();
   printf("\n\r ப A (1 - 祫 / 2 - ணࠬ)?:");
   while((c = getch()) != '1' && c != '2');
   aPlayer = (c == '2') ? Program : Human;
   printf(aPlayer == Human ? "" : "ணࠬ");
   if (aPlayer == Program)
   {
      printf("\n\r㤥  ENTER, ⮡ ணࠬ 諠? (1-Y/2-N):");
      while((c = getch()) != '1' && c != '2');
      printf(c == '1' ? "" : "");
   }
   else
      c = '1';
   wEnt = c == '1';
   printf("\n\r 室 : 1 - ப , 2 - ப ? ");
   while((c = getch()) != '1' && c != '2');
   firstToPlay = c == '1' ? aToPlay : bToPlay;
}/*askTunes*/

void setLocs(void)
{
   int i;

   for (i=0; i < 6; i++)		/* न ஢  	*/
   {
      y[i] = cornY + stepY * 2;
      y[i + 7] = cornY;
      x[i] = cornX + stepX * i;
      x[i + 7] = cornX + stepX * (5 - i);
   }
                                        /*  - न 客: */
   x[6]  = cornX + stepX * 6;           /*  ப  - ࠢ.     */
   x[13] = cornX - stepX;               /*  ப B - ᫥.      */
   y[6]  =                              /*  ᯮ          */
   y[13] = cornY + stepY;               /*   ਧ⠫.        */
}/*setLocs*/

void initialize(void)
{
   int i;

   randomize();
   clrscr();

   for(i=0; i < 6;i++)
      rootPos.desk[i] = rootPos.desk[i+7] = 6;
   rootPos.desk[6] = rootPos.desk[13] = 0;
   rootPos.forced = 0;

   setLocs();
   for(i=cornX - stepX; i <= cornX + 6 * stepX; i++)
   {
      gotoxy(i, cornY - 1);
      printf("");
      gotoxy(i, cornY + stepY * 2 + 1);
      printf("");
   }

   for(i = 0; i < 6; i++)
   {
      gotoxy (x[i],    y[i]    + 2); printf ("%2d", i);
      gotoxy (x[12-i], y[12-i] - 2); printf ("%2d", 12 - i);
   }
   drawScreen();
}/*initialize*/

void drawScreen(void)
{
   int i;

   for(i=0;i<14;i++)
   {
      gotoxy (x[i],y[i]);
      printf ("%2d",rootPos.desk[i]);
   }
}/*drawScreen*/

int ABprune(PNODE p, int alpha, int beta)
/* Alpha-beta pruning (⮤ ࠭  業)   ..        */
/* 頥 業  樨 p.				*/
{
   int 	m, t;
   PNODE 	pcurPos;

   cL++;
   pcurPos = first(p);		/* ᫨  樨 p  뭮,	*/
				/* ୥ NULL.				*/
   if(pcurPos == NULL) 
   {
      cL--;
      return estimate(p);	/*  室  楤,		*/
   }   				/*   ନ쭠.		*/
   else 
   {
      m = alpha;
      while(m < beta && pcurPos != NULL)
      {
         t = -ABprune(pcurPos, -beta, -m);
         if(t > m)
            m = t;
         pcurPos = next(p);
      }
   }
   cL--;
   return m;				/*   - 室   	*/
	   				/* ⠫ 権.		*/
}/*ABprune*/

PNODE first(PNODE p)
{
   if(cL < maxLevel)
   {
      wStack[cL].forced = 0;
      wStack[cL].move[0] = Aplays(*p) ? -1 : 6;
      return next(p);
   }
   return NULL;
}/*first*/

void retPos(PNODE p)
{
   int i;

                      /* 砫 ᪮㥬   p         */
   memmove(wStack[cL].desk,p->desk,sizeof(p->desk));
                      /*  த ஢ 室    */
                      /*  樨, ।饩 ⥪饩.    */
   for(i=0;i<wStack[cL].forced;i++)
   {
      scatterStones(wStack[cL].desk,wStack[cL].move[i]);
                      /*      ⮩!!	*/
   }
}/*retPos*/

PNODE next(PNODE p)
{
   int U = Aplays(*p) ? 6 : 13;
   int move,t;
		/****  । 室.	****/
   retPos(p); /* ந   । 室.     */
                         /*  ⨬ 室.         */
   move = wStack[cL].move[wStack[cL].forced];
   while(++move < U && wStack[cL].desk[move] == 0);
   wStack[cL].move[wStack[cL].forced] = move;

   if(move == U)
      return (wStack[cL].forced-- == 0) ? NULL : next(p);
   else
   {               /* move < U     */
      t = scatterStones(wStack[cL].desk,move);
      if(t)
      {
         if(isEmpty(&wStack[cL]))
            return &wStack[cL];
         else
         { /* 1.2. (!) */
            wStack[cL].move[++wStack[cL].forced] =
         			Aplays(*p) ? -1 : 6;
            return next(p);
         }
      }
      else
         return &wStack[cL];
   }
}/*next*/

int estimate(PNODE p)
/* ᫨ 業 樨.			*/
{
    int value = p->desk[6] - p->desk[13];
    if(!Aplays(*p)) value = -value;
    return value;
}/*estimate*/

int findMove(PNODE p)
{
   int		res=0;
   int 	t,m;
   PNODE 	pcurPos=&curPos;

   if((pcurPos=getFirst(p)) == NULL)
   {
      return 0;			/*  室  楤,		*/
   }   				/*   ନ쭠.		*/
   else
   {
      m = -200;
      while(pcurPos != NULL)
      {
	 cL = -1;               /* "।ࢮ" ﭨ ஢.       */
	 t = -ABprune(pcurPos,-200, 200);
         if(t > m || (t == m && random(2)))
         {
	    m = t;
	    bestMove = curPos;
	    res++;
	 }
	 pcurPos = getNext(p);
      }
   }
   return res;
}/*findMove*/

PNODE getFirst(PNODE p)
{
   cL=0;                        /* ⮡ ᯮ짮 first!         */
   first(p);         		/* 㥬 ࢮ 뭠 p.          */
   curPos = wStack[0];
   return &curPos;
}/*getFirst*/

PNODE getNext(PNODE p)
{
   PNODE pcurPos;

   wStack[0] = curPos; cL = 0;    /*    ⥪      */
   pcurPos = next(p);             /* ᣥ㥬 ᫥.       */
   if(pcurPos)
   {
      curPos = wStack[0];
      pcurPos = &curPos;
   }
   return pcurPos;
}/*getNext*/

void sayBye(void)
{
   gotoxy(1, 1);
   printf(" 祭.  ENTER.");
   waitEnter();
}/*sayPress*/

void saveGame(void)
{
   int i,k;
   FILE *file = fopen("lastGame.klh","wt");

   gotoxy(1,1);

   fprintf(file, "\nப A : %s",
                aPlayer == Human ? "" : "ணࠬ");
   fprintf(file, "\nப B : ணࠬ");
   fprintf(file, "\n 室 ப %c\n\n",
			firstToPlay == aToPlay ? 'A' : 'B');

   for(i=0; i<gameLength; i++)
   {
      fprintf(file,"\n%2d) ",i+1);
      if(gameA[i].move[0] != -1)
      {
         fprintf(file,"A:");
         for(k=0; k<=gameA[i].forced;k++)
         {
            fprintf(file," %2d",gameA[i].move[k]);
         }
      }
      fprintf(file,"\t\tB:");
      for(k=0; k<=gameB[i].forced;k++)
      {
         fprintf(file," %2d",gameB[i].move[k]);
      }
   }
   fprintf(file,"\n\n  砭 :\n"
   	        "\t   - %d\n"
   	        "\t  B - %d\n",
                rootPos.desk[6],rootPos.desk[13]);
   fclose(file);
}/*saveGame*/

int getMove(whoToMove movesNow)
{
   switch(movesNow)
   {
      case Human:
	 askHuman();
	 break;
      case Program:
	 askProgram();
   	 rootPos = bestMove;
	 break;
   }
   return isEmpty(&rootPos);
}/*getMove*/

void askHuman(void)
{
   int rep=0, move;

   rootPos.forced = 0;
   do
   {
      if((move=askMove()) == -1)
	 exit(0);		/*  <ESC> - 뢠  	*/
      rep = makeMove(move);
      rootPos.move[rootPos.forced++] = move;
   } while(rep);

   rootPos.forced--;			/* !!! extent ..  1 	*/
   					/*  - 室!!!	*/

}/*askHuman*/

int askMove(void)
{
   int move, ch;

   while(1)
   {                   /*    짮⥫      */
      gotoxy(1,1); clreol();
      printf(" 室: ");

      ch = bioskey(0) & 0xFF;			/*     	*/

      if(ch == 27)	/*   <ESC> -			*/
	 return -1;	/* ୥  ⨬  .	*/

      putchar(ch);
      move = ch - '0';				/* 㥬 ⨥     */
      if (!isdigit(ch) || move > 5 || rootPos.desk[move] == 0)
      {
	 putchar('\a');			/*   : "㤭"  -	*/
	 continue;			/*   - ਬ  	*/
      }
      break;				/*  - 室  横	*/
   }
   return move;

}/*askMove*/

void sayThinking(void)
{
   gotoxy(1,1); clreol();
   lowvideo(); textattr(LIGHTGRAY+BLINK);
   cprintf("㬠...");
   textattr(LIGHTGRAY);
}/*sayThinking*/

void sayMoving(int k)
{
   int i;

   gotoxy(1,1); clreol();
   lowvideo(); textattr(LIGHTGRAY);
   cprintf(" ");
   for(i=k;i<=bestMove.forced;i++)
      cprintf(" %2d",bestMove.move[i]);
}/*sayMoving*/

void waitEnter(void)
{
   while(getch() != 13);	/*   ENTER ࠢ 13, ࠢ?	*/
}/*waitEnter*/

void askProgram(void)
{
   int i;

   sayThinking();
   findMove(&rootPos);
   for(i=0;i<=bestMove.forced;i++)
   {
      sayMoving(i);
      if(wEnt)
         waitEnter();
      makeMove(bestMove.move[i]);
   }
}/*askProgram*/

int makeMove(int move)
{
   int rep;

   rep = scatterStones(rootPos.desk,move);
   drawScreen();
   if(isEmpty(&rootPos)) rep = 0;
   return rep;
}/*makeMove*/

#define INC(i)          i++;                                    \
      if (move < 6 /*  ப A */ &&                        \
          i == 13  /* ࠥ    ப B */     \
          ||                                                    \
          move > 6 /*  ப B */ &&                        \
          i == 14  /* 諨   ᨢ */) i = 0;         \
      else                                                      \
      if (move > 6 /*  ப B */ &&                        \
          i == 6   /* ய⨬  ப A */) i++;

int scatterStones(int desk[14], int move)
{
   int i, fin=0, stones;

   i = move;
   stones = desk[i];            /* ⢮ ।塞      */
   desk[i] = 0;
   while(stones--)
   {                            /*  誨:    */
      INC(i);                            /* 稬 i                 */
      desk[i]++;                         /*  । 襪.  */
   }
                             /*** ࠢ 1.3: ***/
                             /*  稫   ⮬ .    */
   if(desk[i] == 1 && desk[12-i] > 0 &&      /*  ⨢ . */
      ((move < 6 &&                          /*  ப A            */
         i < 6) ||                           /*  稫   .  */
       (move > 6 &&                          /*  ப B            */
        i > 6 && i < 13)))                   /*  稫   .  */
   {                 
      desk[move<6? 6:13] += desk[i] + desk[12-i];
      desk[i] = desk[12-i] = 0;
   }
		/*** 騬  ⮬,  㦭 ਬ ࠢ 1.2. ***/
   if (move < 6 && i == 6 || move > 6 && i == 13) fin = 1;
   return fin;
}/*scatterStones*/

#undef INC

int isEmpty(PNODE p)
{
   int i,fin;
                                /*** ࠢ 1.4. ***/
   fin = 1;
   for(i=0;i<6;i++) if(p->desk[i]) fin = 0;
   if(fin)
   {
      for(i=7;i<13;i++)
      {
         p->desk[13] += p->desk[i]; p->desk[i] = 0;
      }
      return 1;
   }
   fin = 1;
   for(i=7;i<13;i++) if(p->desk[i]) fin = 0;
   if(fin)
      for(i=0;i<6;i++)
      {
         p->desk[6] += p->desk[i]; p->desk[i] = 0;
      }
   return fin;
}/*isEmpty*/

