;*******************************************************;
;                                                       ;
;       Turbo Pascal Version 7.0                        ;
;       Extended Strings Unit                           ;
;       Version 1.1                                     ;
;                                                       ;
;       Copyright (c) 1993 by RDA Software              ;
;                                                       ;
;*******************************************************;

.MODEL TPASCAL
.CODE
LOCALS @@


; Procedure StrToLower(Var Str: String);
; 楤 ८ࠧ ப Str   ॣ.

PUBLIC  StrToLower

	Str_	equ	DWord Ptr ss:[bx + 4]

    StrToLower	PROC	Far
	mov	bx, sp
	les	di, Str_
	xor	cx, cx
	mov	cl, es:[di]
	jcxz	@@4
	cld
	inc	di
   @@1: mov	al, es:[di]
	cmp	al, 'A'
	jb	@@3
	cmp	al, 'Z'
	jbe	@@2
	cmp	al, ''
	jb	@@3
	cmp	al, ''
	jbe	@@2
	cmp	al, ''
	ja	@@3
	add	al, 80
	jmp	@@3
   @@2: add	al, 32
   @@3: stosb
	LOOP	@@1
   @@4: ret	4
    StrToLower	ENDP


; Procedure StrToUpper(Var Str: String);
; 楤 ८ࠧ ப Str  孥 ॣ.

PUBLIC  StrToUpper

	Str_	equ	DWord Ptr ss:[bx + 4]

    StrToUpper	PROC	Far
	mov	bx, sp
	les	di, Str_
	xor	cx, cx
	mov	cl, es:[di]
	jcxz	@@4
	cld
	inc	di
   @@1: mov	al, es:[di]
	cmp	al, 'a'
	jb	@@3
	cmp	al, 'z'
	jbe	@@2
	cmp	al, ''
	jb	@@3
	cmp	al, ''
	jbe	@@2
	cmp	al, ''
	jb	@@3
	cmp	al, ''
	ja	@@3
	sub	al, 80
	jmp	@@3
   @@2: sub	al, 32
   @@3: stosb
	LOOP	@@1
   @@4: ret	4
    StrToUpper	ENDP


; Function  StrChr(Str: String; Sim: Char): Boolean;
; 㭪 ஢ 宦 ᨬ Chr  ப Str.

PUBLIC	StrChr

	Str_	equ	DWord Ptr ss:[bx + 6]
	Sim	equ	ss:[bx + 4]

    StrChr	PROC	Far
	mov	bx, sp
	les	di, Str_
	mov	ax, Sim
	xor	cx, cx
	mov	cl, es:[di]
	jcxz	@@2
	inc	di
	cld
	REPNE	scasb
	je	@@1
	xor	al, al
	jmp	@@2
   @@1: mov	al, 1
   @@2: ret	6
    StrChr	ENDP


; Function  StrIChr(Str: String; Sim: Char): Boolean;
; 㭪 ஢ 宦 ᨬ Chr  ப Str,
;   ⮬ 㪢 孥   ॣ஢
; 묨.

PUBLIC	StrIChr

	Str_	equ	DWord Ptr ss:[bx + 8]
	Sim	equ	ss:[bx + 6]

    StrIChr	PROC	Far
	push	ds
	mov	bx, sp
	lds	si, Str_
	mov	ax, Sim
	call	@@5
	mov	bl, al
	cld
	lodsb
	or	al, al
	jz	@@2
	xor	cx, cx
	mov	cl, al
   @@1: lodsb
	call	@@5
	cmp	al, bl
	je	@@3
	LOOP	@@1
   @@2: xor	ax, ax
	jmp	@@4
   @@3: mov	al, 1
   @@4: pop	ds
	ret	6
   @@5: cmp	al, 'A'
	jb	@@8
	cmp	al, 'Z'
	ja	@@7
   @@6: add	al, 32
	retn
   @@7: cmp	al, ''
	jb	@@8
	cmp	al, ''
	jbe	@@6
	cmp	al, ''
	ja	@@8
	add	al, 80
   @@8: retn
    StrIChr	ENDP


; Function StrCmp(Str1, Str2: String): Integer;
; 㭪 頥 १ ࠢ  ப:
;    -1, ᫨ Str1 < Str2;
;     0, ᫨ Str1 = Str2;
;     1, ᫨ Str1 > Str2.

PUBLIC StrCmp

	Str1	equ	DWord Ptr ss:[bx + 10]
	Str2	equ	DWord Ptr ss:[bx + 6]

    StrCmp	PROC	Far
	push	ds
	mov	bx, sp
	cld
	lds	si, Str1
	les	di, Str2
	xor	cx, cx
	mov	cl, [si]
	mov	dl, es:[di]
	mov	dh, cl
	cmp	dl, cl
	jae	@@0
	mov	cl, dl
   @@0: inc	si
	inc	di
	REPE	cmpsb
	jb	@@1
	ja	@@2
	cmp	dh, dl		; ࠢ  ப
	jb	@@2
	ja	@@3	
	xor	ax, ax
	jmp	@@3
   @@1: mov	ax, -1
	jmp	@@3
   @@2: mov	ax, 1
   @@3: pop	ds
	ret	8
    StrCmp	ENDP


; Function StrICmp(Str1, Str2: String): Integer;
; 㭪 頥 १ ࠢ  ப,
;  㪢 孥   ॣ஢ 묨:
;    -1, ᫨ Str1 < Str2;
;     0, ᫨ Str1 = Str2;
;     1, ᫨ Str1 > Str2.

PUBLIC StrICmp

	Str1	equ	DWord Ptr ss:[bx + 10]
	Str2	equ	DWord Ptr ss:[bx + 6]

    StrICmp	PROC	Far
	push	ds
	mov	bx, sp
	cld
	lds	si, Str1
	les	di, Str2
	xor	cx, cx
	mov	cl, [si]
	mov	dl, es:[di]
	mov	dh, cl
	cmp	dl, cl
	jae	@@0
	mov	cl, dl
   @@0: inc	si
	inc	di
   @@1: lodsb			; 砫 横 ࠢ
	call	@@5		; ८ࠧ  UpCase ᨬ  Str1
	mov	bl, al
	mov	al, es:[di]
	call	@@5		; ८ࠧ  UpCase ᨬ  Str2
	cmp	bl, al
	jb	@@2
	ja	@@3
	inc	di
	LOOP	@@1
	cmp	dh, dl		; ࠢ  ப
	jb	@@2
	ja	@@3
	xor	ax, ax
	jmp	@@4
   @@2: mov	ax, -1
	jmp	@@4
   @@3: mov	ax, 1
   @@4: pop	ds
	ret	8
   @@5: cmp	al, 'A'		; ८ࠧ ᨬ  UpCase
	jb	@@8
	cmp	al, 'Z'
	ja	@@7
   @@6: add	al, 32
	retn
   @@7: cmp	al, ''
	jb	@@8
	cmp	al, ''
	jbe	@@6
	cmp	al, ''
	ja	@@8
	add	al, 80
   @@8: retn
    StrICmp	ENDP


; Function StrNCmp(Str1, Str2: String; N: Byte): Integer;
; 㭪 頥 १ ࠢ  ப,
; ࠢ  , 祬  N ᨬ:
;    -1, ᫨ Str1 < Str2;
;     0, ᫨ Str1 = Str2;
;     1, ᫨ Str1 > Str2.

PUBLIC StrNCmp

	N	equ	ss:[bx + 6]
	Str1	equ	DWord Ptr ss:[bx + 12]
	Str2	equ	DWord Ptr ss:[bx + 8]

    StrNCmp	PROC	Far
	push	ds
	mov	bx, sp
	cld
	lds	si, Str1
	les	di, Str2
	mov	dl, N
	xor	cx, cx
	cmp	dl, [si]
	jbe	@@1
	mov	cl, [si]
	inc	cx
	jmp	@@2
   @@1: mov	cl, dl
	inc	si
	inc	di
   @@2:	REPE	cmpsb
	jb	@@3
	ja	@@4
	xor	ax, ax
	jmp	@@5
   @@3: mov	ax, -1
	jmp	@@5
   @@4: mov	ax, 1
   @@5: pop	ds
	ret	10
    StrNCmp	ENDP


; Procedure StrSet(Var Str: String; Sim: Char);
; 楤 ⠭  ᨬ ப  祭,
;  ࠬ஬ Sim.

PUBLIC	StrSet

	Str_	equ	DWord Ptr ss:[bx + 6]
	Sim	equ	ss:[bx + 4]

    StrSet	PROC	Far
	mov	bx, sp
	les	di, Str_
	mov	ax, Sim
	cld
	xor	cx, cx
	mov	cl, es:[di]
	jcxz	@@1
	inc	di
	REP	stosb
   @@1: ret	6
    StrSet	ENDP


; Procedure StrNSet(Var Str: String; Sim: Char; N: Byte);
; 楤 ⠭ N ᨬ ப  祭,
;  ࠬ஬ Sim.  ப ⠭  N.

PUBLIC	StrNSet

	Str_	equ	DWord Ptr ss:[bx + 8]
	Sim	equ	ss:[bx + 6]
	N	equ	ss:[bx + 4]

    StrNSet	PROC	Far
	mov	bx, sp
	les	di, Str_
	cld
	xor	cx, cx
	mov	ax, N
	stosb
	mov	cl, al
	jcxz	@@1
	mov	ax, Sim
	REP	stosb
   @@1: ret	8
    StrNSet	ENDP


; Function Contains(Str1, Str2: String): Byte;
; 㭪 頥  樨 ࢮ ᨬ  ப Str1,
;  ᮤন  ப Str2  0, ᫨   ᨬ  Str1
;    Str2.

PUBLIC Contains

	Str1	equ	DWord Ptr ss:[bx + 10]
	Str2	equ	DWord Ptr ss:[bx + 6]

    Contains	PROC	Far
	push	ds
	mov	bx, sp
	cld
	lds	si, Str1
	les	di, Str2
	xor	ax, ax
	lodsb
	push	si
	or	ax, ax
	jz	@@2
	mov	bx, ax
	mov	al, es:[di]
	or	ax, ax
	jz	@@2
	inc	di
	mov	dx, di
	mov	cx, ax
   @@1: push	cx
	mov	di, dx
	lodsb
	REPNE	scasb
	pop	cx
	je	@@3
	dec	bx
	jnz	@@1
   @@2: xor	ax, ax
	pop	bx
	jmp	@@4
   @@3: mov	ax, si
	pop	bx
	sub	ax, bx
   @@4: pop	ds
	ret	8
    Contains	ENDP


; Procedure DelRightSpace(Var Str: String);
; 楤 㤠 騥 ஡  ப Str.

PUBLIC  DelRightSpace

	Str_	equ	DWord Ptr ss:[bx + 4]

    DelRightSpace	PROC	Far
	mov	bx, sp
	les	di, Str_
	xor	cx, cx
	mov	cl, es:[di]
	jcxz	@@2
	mov	bx, di
	add	di, cx
	mov	dx, cx
	mov	al, ' '
	std
	REPE	scasb
	jcxz	@@1
	inc	cl
   @@1: mov	es:[bx], cl
   @@2: ret	4
    DelRightSpace	ENDP


; Procedure DelLeftSpace(Var Str: String);
; 楤 㤠 騥 ஡  ப Str.

PUBLIC  DelLeftSpace

	Str_	equ	DWord Ptr ss:[bx + 4]

    DelLeftSpace	PROC	Far
	mov	bx, sp
	les	di, Str_
	xor	cx, cx
	mov	cl, es:[di]
	jcxz	@@2
	mov	bx, di
	inc	di
	mov	si, di
	mov	al, ' '
	cld
	REPE	scasb
	mov	al, cl
	jcxz	@@1
	inc	al
	inc	cl
	dec	di
	push	ds es
	pop	ds
	xchg	di, si
	REP	movsb
	pop	ds
   @@1: mov	di, bx
	stosb
   @@2: ret	4
    DelLeftSpace	ENDP

END
