
             {---------------------------------------------------}
             {  । 楤 㯠  ᯠ }
             { ⮢ ᨢ 쥬   64        }
             {---------------------------------------------------}
             {  ணࠬ஢ : Turbo Pascal  V 6.0       }
             {---------------------------------------------------}
             {  ᮧ : 21/11/1991                        }
             {  ᫥  : 23/09/1992             }
             {---------------------------------------------------}
             { (c) 1991, 1992, ਭ , ᫠         }
             {---------------------------------------------------}


 {  ᨢ ⮨  । 㯠       }
 { 㯠 ᫥⥫쭮⥩. ࢮ ᥣ          }
 { 㯠.                                                }

 { ଠ 㯠 ᫥⥫쭮:                        }
 {                                                               }
 {        1              2      3                    }
 {   |1|X|X|X|X|X|X|X|       \             /                     }
 {    ^  \__________/          \_________/                       }
 {    |       \                     |                            }
 {  ਧ    ⢮       ࢮ                }
 {  㯠    .      ᫥⥫쭮                }
 {             ᫥.          㯠 ᨢ             }
 {                                                               }
 {                                                               }
 {                                                               }
 { ଠ 㯠 ᫥⥫쭮 :                     }
 {                                                               }
 {               1       2      i = 1...N           }
 {            /   \              /      \                        }
 {   訩     \__________/          \                 }
 {       0               \                   ᫥⥫쭮  }
 {   ਧ            ⢮                           }
 {  㯠       㯠                            }
 {  ᫥⥫쭮  ᫥⥫쭮                       }

UNIT PackAr;

INTERFACE

USES Crt, AnBuf;

PROCEDURE PackArray ( SrBoxPtr : BufferPtr; SrSize : WORD;
                      VAR DestBoxPtr : BufferPtr; VAR DestSize : WORD );
          {  ᨢ }

PROCEDURE UnPackArray ( VAR SrBoxPtr : BufferPtr; VAR SrSize : WORD;
                          DestBoxPtr : BufferPtr; DestSize : WORD );
          { ᯠ ᨢ }

IMPLEMENTATION

CONST
     MaxLend = 127;
               { ᨬ쭠  ᪮ 饩 }
               { ᫥⥫쭮                       }

     MaxSizeFind = $1000;
               { ᨬ쭠 㡨 ᪠ 4 K byte }

     MinLend = 4;
               { 쭠  ᪠ }

     StepFind = MaxSizeFind DIV MaxLend;
               {  ᪠ }

{----------------------------------------------------------}

PROCEDURE FatalError ( Line : STRING );

          { 뤠 ᮮ饭  ᪮ 訡 }
BEGIN
     WINDOW ( 1, 1, 80, 25 );
     TEXTCOLOR ( LIGHTGRAY );
     TEXTBACKGROUND ( BLACK );
     CLRSCR;
     WRITELN ( #7 );
     WRITELN ( '᪨ ᡮ  㫥 PackAr' );
     WRITELN ( Line );
     WRITELN ( '믮 ணࠬ ४頥...' );
     HALT ( 1 )

END; { proceddure FatalError }

{----------------------------------------------------------}

PROCEDURE PackArray ( SrBoxPtr : BufferPtr; SrSize : WORD;
                      VAR DestBoxPtr : BufferPtr; VAR DestSize : WORD );
          {  ᨢ }
VAR
   Index_S : WORD;
         {  ᬠਢ  室 ᨢ }

   Index_D : WORD;
         {  ᬠਥ  㯠 ᨢ }

   HelpNumber : WORD;
         {  砫  ᫥ ᫥⥫쭮 }
         {          㯠 ᨢ                    }

   AddrRecord : WORD;
         {  ࢮ  饩 ᫥⥫쭮 }

   Lend : BYTE;
         {  饩 ᫥⥫쭮 }

   HelpArray : ARRAY [ 0..255 ] OF BYTE;
         { ᯮ⥫ ᨢ ᪠ }

   Index : WORD;

  {..................................}


FUNCTION CheckRepeatBytes ( VAR Size : BYTE; { 쪮   }
            VAR Location : WORD {  ᯮ 騥  }
            ) : BOOLEAN;
         { 㭪 ।    ᫥⥫쭮   }

         {  ᪮७ ᪠ ᯮ짮  ᪠ -   }
         {  -- / . . "   "}
VAR
   BeginFind : WORD;
         { 砫  ᪠ ᫥⥫쭮 }
         {  㯠 ᨢ                     }

   MaxFindLend : BYTE;
         { ᨬ쭠 䠪᪠  ᪮ ᫥⥫쭮 }

   CurrentIndex : WORD;
         {  ⥪饣 ࠢ ᨬ }

   CurrentSize : BYTE;
         { 饥 ⢮ }

   CurrentAddres : WORD;
         { 騩  }

   CompByte, StartByte : BYTE;
         { ࠢ  }

   SingFind : BOOLEAN;
         { ਧ ᪠ }

   CurrentLend : BYTE;
         {  ᨬ쭠  ᪠ }

   SizeFind : WORD;
         { 㡨 ᪠ }

BEGIN
       { 塞  砫  ᪠ ᫥⥫쭮 }

     IF ( Index_S <= MaxSizeFind ) THEN
        BeginFind := 1
     ELSE
         BeginFind := Index_S - MaxSizeFind;

     SizeFind := Index_S - BeginFind;

       { 塞 ᨬ 䠪  }
       {   ᪮ ᫥⥫쭮             }

     IF ( SrSize - Index_S >= 127 ) THEN
        MaxFindLend := 127
     ELSE
         MaxFindLend := SrSize - Index_S;

     CurrentLend := SizeFind DIV StepFind;
     IF ( CurrentLend > MaxFindLend ) THEN
        CurrentLend := MaxFindLend;
     IF ( CurrentLend < MinLend ) THEN
        CurrentLend := MinLend;

       { ᫨ ᨬ쭠  < MinLend,     ᫠ }

     IF ( MaxFindLend < MinLend ) THEN
        BEGIN
             CheckRepeatBytes := FALSE;
             EXIT
        END;

        { 樠 ६ 横 }

     CurrentSize := 0;        { 騩  ࠧ }
     Size := MinLend - 1;     { ᨬ 㯠뢠 ࠧ }
     CurrentIndex := Index_S;
     StartByte := SrBoxPtr^ [ CurrentIndex ];
     CompByte := StartByte;
     CheckRepeatBytes := FALSE;

        {  ᪠ ᫥⥫쭮 }

     WHILE ( BeginFind < CurrentIndex ) DO

           IF ( SrBoxPtr^ [ BeginFind ] <> CompByte ) THEN
               BEGIN
                    { ᬮਬ  ਠ :                       }
                    { 1. ࠭ ࠢ  ᮢ  Size <> 0 }
                    {  2.  ᮯ - Size = 0                       }

                    IF ( CurrentSize = 0 ) THEN
                       BEGIN
                            { ᫨  ᮢ,  㢥稢  1 砫 }
                            {  ᪠                                   }

                            INC ( BeginFind );

                            DEC ( SizeFind );
                            IF ( ( Lo ( SizeFind ) = 0 ) OR
                                 ( Lo ( SizeFind ) = 0 ) ) THEN
                               BEGIN
                                    CurrentLend := SizeFind DIV StepFind;
                                    IF ( CurrentLend > MaxFindLend ) THEN
                                       CurrentLend := MaxFindLend;
                                    IF ( CurrentLend < MinLend ) THEN
                                       CurrentLend := MinLend
                               END
                       END
                    ELSE
                        BEGIN
                             IF ( CurrentSize > Size ) THEN
                                { ᫨ ᮢ 襥 ⢮  }
                                { 祬 ࠭,   ࠬ     }
                                {  ᫥⥫쭮           }
                                 BEGIN
                                      CheckRepeatBytes := TRUE;
                                      Size := CurrentSize;
                                      Location := CurrentAddres
                                 END;
                             CompByte := StartByte;
                             CurrentIndex := Index_S;
                             CurrentSize := 0
                        END
               END
           ELSE
               BEGIN
                    { ᫨ ࠭ ࠢ   ᮢ,    }
                    {   । ᯮ }
                    { ᪮ ᫥⥫쭮                     }

                    IF ( CurrentSize = 0 ) THEN
                       BEGIN
                            {        ᯮ짮 }
                            {  ᯮ⥫쭮 ᨢ HelpArray       }
                            {  室  MinLend ᨬ          }

                            IF ( SrBoxPtr^ [ BeginFind + MinLend - 1 ] <>
                                 SrBoxPtr^ [ CurrentIndex + MinLend - 1 ] ) THEN
                               BEGIN
                                    {  室  MinLend ᨬ          }

                                    BeginFind := BeginFind +
                                       HelpArray [ SrBoxPtr^ [ BeginFind + MinLend - 1 ] ];
                                    SingFind := FALSE;
                               END
                            ELSE
                                BEGIN
                                     CurrentAddres := BeginFind;
                                     SingFind := TRUE
                                END
                       END;
                    { 稢  1 ࠧ,  ᪠   }
                    { 砫 ᪠ ᫥⥫쭮               }

                    IF ( SingFind ) THEN
                       BEGIN
                            INC ( CurrentSize );
                            INC ( CurrentIndex );
                            CompByte := SrBoxPtr^ [ CurrentIndex ];
                            INC ( BeginFind );

                            DEC ( SizeFind );
                            IF ( ( Lo ( SizeFind ) = 0 ) OR
                                 ( Lo ( SizeFind ) = 0 ) ) THEN
                               BEGIN
                                    CurrentLend := SizeFind DIV StepFind;
                                    IF ( CurrentLend > MaxFindLend ) THEN
                                       CurrentLend := MaxFindLend;
                                    IF ( CurrentLend < MinLend ) THEN
                                       CurrentLend := MinLend
                               END;

                    { ᫨ ᮢ ᨬ쭮-⨬ ⢮ , }
                    {  ४頥 쭥訩                        }

                            IF ( CurrentSize >= CurrentLend ) THEN
                               BEGIN
                                    CheckRepeatBytes := TRUE;
                                    Size := CurrentSize;
                                    Location := CurrentAddres;
                                    EXIT
                               END
                       END
             END


END; { function CheckRepeatBytes }

  {..................................}

PROCEDURE IncLend;

          { 祭 ।⥫  㯠 }
          {        ᫥⥫쭮  1             }
BEGIN
     IF ( DestBoxPtr^ [ HelpNumber + 1 ] = 255 ) THEN
        BEGIN
             INC ( DestBoxPtr^ [ HelpNumber ] );
             DestBoxPtr^ [ HelpNumber + 1 ] := 0
        END
     ELSE
         INC ( DestBoxPtr^ [ HelpNumber + 1 ] )

END; { procedure IncLend }

  {..................................}

FUNCTION GetLend : WORD;

         { 頥 ⥪  ᫥ 㯠 }
         {        ᫥⥫쭮                        }
BEGIN
     GetLend := DestBoxPtr^ [ HelpNumber ] * $100 +
                DestBoxPtr^ [ HelpNumber + 1 ]

END; { function GetLend }

  {..................................}

BEGIN
     IF ( SrSize < 10 ) THEN
        FatalError ( '誮 쪠 室 ᫥⥫쭮' );

     Index_S := 1;
         { ⮢ ᯮ⥫ ᨢ ᪠ }

     FOR Index := 0 TO 255 DO
         HelpArray [ Index ] := MinLend;
     FOR Index := MinLend - 1 DOWNTO 1 DO
         HelpArray [ SrBoxPtr^ [ Index ] ] := Index;


          { ࠧ㥬 ଠ樮   㯠 }
          {            ᫥⥫쭮                  }

     DestBoxPtr^[ 1 ] := 0; { 室  㯠 . }
     DestBoxPtr^[ 2 ] := 0; {   ࠢ 0                          }

     HelpNumber := 1; { 㪠⥫   ।  }

     Index_D := 3; {  ᢮  㯠 ᨢ }


     WHILE ( Index_S <= SrSize ) DO   {  横 㯠 }

                { 뢠 㭪 ஢ન  㡫㥬  }
                {            ᫥⥫쭮                  }

           IF ( CheckRepeatBytes ( Lend, AddrRecord ) ) THEN
              BEGIN
                { ᫨  㡫㥬 ᫥⥫쭮  }
                {  ,  "뢠" ଠ樮  }
                {  㯠 ᫥⥫쭮, ᮧ     }
                {   㯠 ᫥⥫쭮  ⥬   }
                { ᮧ   ⮩ ᫥⥫쭮     }
                { ᫨  㯠 ᫥⥫쭮  }
                { 㫥 ,   㯠 ᮧ   }
                {  .                                       }

                   IF ( ( Lend > MaxLend ) OR ( Lend < MinLend ) ) THEN
                      FatalError ( '訡 ।   㯠' );

                      { 稢  ⥪饣   室 ᨢ }
                      {    ᫥⥫쭮                }

                   Index_S := Index_S + Lend;

                      { ᫨  ।饩 㯠 }
                      { ᫥⥫쭮 = 0,       }
                      { 㯠 ᮧ       }

                   IF ( GetLend = 0 ) THEN
                      DEC ( Index_D, 2 );

                      { ⠭ ਧ     }
                      { 㯠 ᫥⥫쭮 }

                   DestBoxPtr^ [ Index_D ] := $80 OR Lend;
                   INC ( Index_D );

                      { ⠭  㯠  }
                      { ᫥⥫쭮  㯠 }
                      { ᨢ                          }

                   DestBoxPtr^ [ Index_D ] := Hi ( AddrRecord ); {  }
                   INC ( Index_D );                              {    }

                   DestBoxPtr^ [ Index_D ] := Lo ( AddrRecord ); {  }
                   INC ( Index_D );                              {    }

                   HelpNumber := Index_D; { 㪠⥫  }

                   DestBoxPtr^[ Index_D ] := 0; { 室  㯠 . }
                   INC ( Index_D );             {   ࠢ 0                          }
                   DestBoxPtr^[ Index_D ] := 0; 
                   INC ( Index_D )

              END
           ELSE
               BEGIN
                 { , 塞  ᨬ  㯠     }
                 { ᫥ࢠ⥫쭮, 塞 ଠ    }
                 {  室  ᫥饬 ᨬ                 }


                    FOR Index := MinLend - 1 DOWNTO 1 DO
                        HelpArray [ SrBoxPtr^ [ Index + Index_S ] ] := Index;
                    HelpArray [ SrBoxPtr^ [ Index_S ] ] := MinLend;

                    DestBoxPtr^ [ Index_D ] := SrBoxPtr^ [ Index_S ];
                    IncLend;
                    INC ( Index_D );
                    INC ( Index_S );
                    IF ( GetLend = $7FFE ) THEN
                       BEGIN
                            HelpNumber := Index_D; { 㪠⥫  }

                            DestBoxPtr^[ Index_D ] := 0; { 室  㯠 . }
                            INC ( Index_D );             {   ࠢ 0                          }
                            DestBoxPtr^[ Index_D ] := 0;
                            INC ( Index_D )
                       END;
               END;

     DestSize := Index_D - 1

END; { procedure PackArray }

{----------------------------------------------------------}

PROCEDURE UnPackArray ( VAR SrBoxPtr : BufferPtr; VAR SrSize : WORD;
                         DestBoxPtr : BufferPtr; DestSize : WORD );
          { ᯠ ᨢ }
CONST
     H = 127;

VAR
   LendHelp : WORD;
   Lend : WORD;
   i : INTEGER;
   Help : WORD;
   Index_S : WORD;
         {  ᬠਢ  室 ᨢ }

   Index_D : WORD;
         {  ᬠਥ  㯠 ᨢ }

    {.....................................}

FUNCTION Len : WORD;

BEGIN
     Len := DestBoxPtr^ [ Index_D ] * $100 +
                                 DestBoxPtr^ [ Index_D + 1 ]

END; { function Len }
 
    {.....................................}

BEGIN
     Index_S := 1;
     Index_D := 1;
     WHILE ( Index_D <= DestSize ) DO
        IF ( DestBoxPtr^ [ Index_D ] <= 127 ) THEN

              { ᫨ ᫥⥫쭮  㯠. ᨢ 㯠 }
          BEGIN
               LendHelp := Len;
               INC ( Index_D , 2 );
               FOR i := 1 TO LendHelp DO
                 BEGIN
                      SrBoxPtr^ [ Index_S ] := DestBoxPtr^ [ Index_D ];
                      INC ( Index_D );
                      INC ( Index_S )
                 END
          END

        ELSE
          BEGIN
               Lend := DestBoxPtr^ [ Index_D ] AND H;
               INC ( Index_D );
               Help := Len;
               FOR i := 1 TO Lend DO
                  BEGIN
                       SrBoxPtr^ [ Index_S ] := SrBoxPtr^ [ Help ];
                       INC ( Index_S );
                       INC ( Help )
                  END;
               INC ( Index_D, 2 )
          END;

     SrSize := Index_S - 1

END; { procedure UnPackArray }

{----------------------------------------------------------}

END.