{ Copyright (c) VES   ᪨ ..  v1.1  2.10.92 }

Unit VESStr;
{ / ࠡ  ப }
interface

type
      CharSet = set of char;

const
      Leading  = 0;
      Trailing = 1;
      Both     = 2;

      LowStr  = 0;
      HighStr = 1;

      Left  = 0;
      Right = 1;

      Present    = 0;
      NotPresent = 1;

      Lower = 0;
      Upper =1;

      WordDelim : CharSet = [
                              ' ', ',', '"', ':', ';', '.',
                              '(', ')', '{', '}', '[', ']',
                              '!', '?', '/', '\', '*', '=',
                              '+', '-', '_', '<', '>', '#',
                              '@', '$', '%', '&', '^', #39, { <- ' }
                              '`', '~', '|'
                            ];

{  }
{  砫 /  ᨬ ப                         }
{       Leading  - 㤠       砫      ᨬ                   }
{ Key = Trailing -   - " -                 - " -                    }
{       Both     -   - " -  砫     - " -                    }
{ 塞 ᨬ । 祭 DelChr                           }
Function Trim ( s : string;  Key : integer;  DelChr : CharSet ) : string;
{  }

{  }
{ ஢ ப  ᫮ ࠧ                                     }
Function Copies ( s : string;  NumCopies : byte ) : string;
{  }

{  }
{ ନ஢ ப  ,    /   }
{  㣮 ப ⮩                                            }
{ Key = LowStr  - ନ஢ 쭮 ப                           }
{       HighStr - ନ஢ ᨬ쭮 ப                          }
Function HighLow ( n : byte;  Key : integer ) : string;
{  }

{  }
{ ॢ /ய 㪢  ப  ய/             }
{ ࠡ뢠 㪢  ⨭, ⠪  ਫ (  . ஢ )  }
{ Key = Lower - ॢ ய 㪢                             }
{       Upper - ॢ  㪢  ய                           }
Function UpLowStr ( s : string;  Key : integer ) : string;
{  }

{  }
{ 祭 ப, 饩  ᨬ, 室            }
{ 묨 ᨬ                                                       }
Function RangeStr ( StSimbol : char;  EndSimbol : char ) : string;
{  }

{  }
{ ࠢ ப ᫥/ࠢ     ⥫  }
{ Key = Left  - ࠢ ப   ࠭                        }
{       Right - ࠢ ப  ࠢ ࠭                       }
Function LeftRight ( s : string;  Len : byte;
                     FillChr : char;  Key : integer ) : string;
{  }

{  }
{ ஢ઠ 祭  ப                                              }
{ s - ப,  ன ஢ 祭                              }
{ AbbrStr - 祭   ப, ஥ ஢             }
{           ࠢ쭮                                             }
{ AbbrLen - 쭠  祭                                      }
Function Abbrev ( s : string;  AbbrStr : string;  AbbrLen : byte ) : boolean;
{  }

{  }
{ ஢ ப      ⥫            }
Function Center ( s : string;  Len : byte;  FillChr : char ) : string;
{  }

{  }
{ ࠢ  ப                                                      }
{ 뤠  ࢮ ᮢ饣 ᨬ  0  ᮢ        }
Function StrCmp ( s1 : string;  s2 : string;  FillChr : char ) : integer;
{  }

{  }
{  ப s2  ப s1                                               }
{ StartPos । 砫  ᪠  ப s1                  }
{ 뤠  ࢮ ᨬ ᪮ ப  0, ᫨        }
Function IndexStr ( s1 : string;  s2 : string;  StartPos : byte ) : integer;
{  }

{  }
{ ஢ઠ 室 ᨬ ப s2  ப s1                        }
{ Key = Present     ॡ ।  ࢮ ᨬ s2,       }
{                    饣 ⠪   s1                           }
{     = NotPresent  ॡ ।  ࢮ ᨬ s2,       }
{                    饣  s1                                    }
{ StartPos ।  樨 ᨬ  s2, 稭  ண        }
{          ᨬ  ப ࠧ᪨  s1                            }
{ 뤠  ࢮ ᨬ, 饣 ( Present )            }
{ 饣 ( NotPresent )  ப,  0, ᫨  ᨬ           }
{  (  )                                              }
Function VerifyStr ( s1 : string;  s2 : string;
                     Key : integer;  StartPos : byte ) : integer;
{  }

{  }
{ ४⨥ ப ᨬ s1 ப s2                                   }
{ StartPos ।  ᨬ ப s1, 稭  ண      }
{ 㤥 ४뢠 ப s2                                            }
{ Len ।  ४뢠饩 ப s2                              }
Function OverStr ( s1 : string;  s2 : string;  StartPos : byte;
                   Len : byte;  FillChr : char ) : string;
{  }

{  }
{  㪠 ᨬ ப                                          }
{  ப s2, 室  s1,   ப s3                  }
{  稭  樨 StartPos                                       }
Function ReplStr ( s1 : string;  s2 : string;
                   s3 : string;  StartPos : byte ) : string;
{  }

{  }
{ ஢ ப                                                     }
Function ReverseStr ( s : string ) : string;
{  }

{  }
{ । ⢠ ᫮  ப  祭 ᫮  ப         }
{*********************************************************}
{*                  TPSTRING.PAS 5.05                    *}
{*        Copyright (c) TurboPower Software 1987.        *}
{* Portions copyright (c) Sunny Hill Software 1985, 1986 *}
{*     and used under license to TurboPower Software     *}
{*                 All rights reserved.                  *}
{*********************************************************}
{--------------- Word manipulation -------------------------------}

function WordCount(S : string; WordDelims : CharSet) : Byte;
  {-Given a set of word delimiters, return number of words in S}

function ExtractWord(N : Byte; S : string; WordDelims : CharSet) : string;
  {-Given a set of word delimiters, return the N'th word in S}
{  }

{  }
{ ।  ᫮                                                   }
function WordLength ( n : byte;  s : string;  WordDelims : CharSet ) : integer;
{  }

{  }
{ । 樨 ࢮ ᨬ 㪠 ᫮  ப             }
Function WordIndex ( n : byte;  s : string;  WordDelims : CharSet ) : integer;
{  }

{  }
{ 祭 㪠 ⢠ ᫮  ப                           }
Function SubWords ( StartWord : byte;  NumWords : byte;
                   s : string;  WordDelims : CharSet ) : string;
{  }

{  }
{ ८ࠧ 祭 ⨯ Byte  祭 ⨯ Char                    }
function ByteToChar ( B : Byte ) : Char;
{  }

{  }
{ ८ࠧ 祭 ⨯ Char  祭 ⨯ Byte                    }
function CharToByte ( C : Char ) : Byte;
{  }

implementation

{  }
Function Trim ( s : string;  Key : integer;  DelChr : CharSet ) : string;

var
    string1 : string;
    SLen1 : byte absolute s;

begin
    string1:=s;
    case Key of
       Leading  : while string1 [1] IN DelChr do  Delete (string1, 1, 1);

       Trailing : while string1 [SLen1] IN DelChr do begin
                      Delete (string1, SLen1, 1); Dec (SLen1)
                                                     end;

       Both     : begin
                      while string1 [SLen1] IN DelChr do begin
                          Delete (string1, SLen1, 1); Dec (SLen1)
                                                         end;
                      while string1 [1] IN DelChr do  Delete (string1, 1, 1);
                  end;
    end;
    Trim:=string1;
end;
{  }

{  }
Function HighLow ( n : byte;  Key : integer ) : string;

var
    byte1 : byte;
    string1  : string;

begin
  case Key of
    LowStr  :   for byte1:=1 to n do
                         string1 [byte1]:=Chr(0);
    HighStr :   for byte1:=1 to n do
                         string1 [byte1]:=Chr($FF);
  end;
  HighLow:=string1;
end;
{  }

{  }
Function RangeStr ( StSimbol : char;  EndSimbol : char ) : string;

var
    string1 : string;
    int1 : integer;

begin
  string1:='';
  if Ord (StSimbol) <= Ord (EndSimbol) then
              for int1:=Ord (StSimbol)  to  Ord (EndSimbol)  do
                      string1:=Concat (string1, Chr (int1) )
                                       else begin
              for int1:=Ord (StSimbol)  to  255  do
                      string1:=Concat (string1, Chr (int1) );
              for int1:=0  to  Ord (EndSimbol)  do
                      string1:=Concat (string1, Chr (int1) );
                                            end;
  RangeStr:=string1;
end;
{  }

{  }
Function Copies ( s : string;  NumCopies : byte ) : string;

var
    byte1 : byte;
    string1 : string;

begin
  string1:='';
  for byte1:=1 to NumCopies do
        string1:=Concat ( s, string1 );
  Copies:=string1;
end;
{  }

{  }
Function LeftRight ( s : string;  Len : byte;
                     FillChr : char;  Key : integer ) : string;

var
    SLen1 : byte absolute s;
    string1 : string;

begin
  case Key of
    Left  : begin
              if SLen1 <= Len then
                          string1:=Concat (s, Copies (FillChr, Len-SLen1))
                             else
                          string1:=Copy (s, 1, Len);
            end;
    Right : begin
              if SLen1 <= Len then
                          string1:=Concat (Copies (FillChr, Len-SLen1), s)
                             else
                          string1:=Copy (s, SLen1-Len+1, Len);
            end;
  end;
  LeftRight:=string1;
end;
{  }

{  }
Function Abbrev ( s : string;  AbbrStr : string;  AbbrLen : byte ) : boolean;

var
    string1 : string;

begin
  string1:=LeftRight (AbbrStr, AbbrLen, ' ', Left);
  if Copy (s, 1, AbbrLen)=string1 then  Abbrev:=True  else  Abbrev:=False;
end;
{  }

{  }
Function Center ( s : string;  Len : byte;  FillChr : char ) : string;

var
    SLen1 : byte absolute s;
    int1 : integer;
    byte1, byte2 : byte;
    string1 : string;

begin
  byte1:=Abs (SLen1-Len);
  if Odd (byte1) then begin
               byte1:=byte1 div 2; byte2:=byte1+1;
                      end
                 else begin
               byte1:=byte1 div 2; byte2:=byte1;
                      end;
  if SLen1 <= Len then
     string1:=Concat ( Copies (FillChr, byte1), s, Copies (FillChr, byte2) )
                 else begin
     string1:=LeftRight ( s, Len+byte2, ' ', Right);
     string1:=LeftRight ( string1, Len, ' ', Left);
                      end;
  Center:=string1;
end;
{  }

{  }
Function StrCmp ( s1 : string;  s2 : string;  FillChr : char ) : integer;

var
    SLen1 : byte absolute s1;
    SLen2 : byte absolute s2;
    int1, int2 : integer;
    byte1 : byte;
    string1, string2 : string;
    
begin
  if SLen1 <= SLen2 then begin
            string1:=LeftRight ( s1, SLen2, FillChr, Left );
            string2:=s2;
                         end
                    else begin
            string1:=s1;
            string2:=LeftRight ( s2, SLen1, FillChr, Left )
                                     end;

  int1:= Length (string1); byte1:=0; int2:=1;
  while ( int2 <= int1 ) AND ( byte1=0 ) do
   begin
     if string1 [int2] <> string2 [int2] then byte1:=int2;
     Inc (int2);
   end;
   StrCmp:=byte1;
end;
{  }

{  }
Function IndexStr ( s1 : string;  s2 : string;  StartPos : byte ) : integer;

var
    SLen1 : byte absolute s1;
    SLen2 : byte absolute s2;
    int1, int2 : integer;
    string1 : string;

begin
  int1:=StartPos;
  if SLen1 < SLen2 then begin  IndexStr:=-1; Exit  end;
  if (StartPos > SLen1) OR (StartPos = 0 ) then begin IndexStr:=-2; Exit end;
  while SLen1 >= (SLen2+int1-1) do
   begin
     string1:= Copy ( s1, int1, SLen2 );
     int2:=StrCmp ( string1, s2, ' ' );
     if int2=0 then begin  IndexStr:=int1; Exit  end
               else Inc (int1);
   end;
   IndexStr:=0;
end;
{  }

{  }
Function VerifyStr ( s1 : string;  s2 : string;
                     Key : integer;  StartPos : byte ) : integer;

var
    SLen1 : byte absolute s1;
    SLen2 : byte absolute s2;
    int1 : integer;
    set1 : CharSet;

begin
  if (StartPos > SLen2) OR (StartPos = 0) then begin VerifyStr:=-1; Exit end;
  set1:=[]; for int1:=1 to SLen1 do set1:=set1+[ s1 [int1] ];
  case Key of
    Present    : begin
                   for int1:=StartPos to SLen2 do
                         if  s2 [int1] IN set1 then begin
                                 VerifyStr:=int1; exit;
                                                    end;
                 end;
    NotPresent : begin
                   for int1:=StartPos to SLen2 do
                         if NOT ( s2 [int1] IN set1 ) then begin
                                 VerifyStr:=int1; exit;
                                                           end;
                 end;
  end;
  VerifyStr:=0;
end;
{  }

{  }
Function UpLowStr ( s : string;  Key : integer ) : string;

var
    SLen1 : byte absolute s;
    int1 : integer;
    string1 : string;

begin
  case Key of
    Lower : for int1:=1 to SLen1 do
                case s [int1] of
                  'A'..'Z',
                  ''..'' : string1 [int1]:=Chr ( Ord (s [int1])+32 );
                  ''..'' : string1 [int1]:=Chr ( Ord (s [int1])+80 );
                       '' : string1 [int1]:='';
                end;
    Upper : for int1:=1 to SLen1 do
                case s [int1] of
                  'a'..'z' : string1 [int1]:=UpCase (s [int1]);
                  ''..'' : string1 [int1]:=Chr ( Ord (s [int1])-32 );
                  ''..'' : string1 [int1]:=Chr ( Ord (s [int1])-80 );
                       '' : string1 [int1]:='';
                end;
  end;
  UpLowStr:=string1;
end;
{  }

{  }
Function OverStr ( s1 : string;  s2 : string;  StartPos : byte;
                   Len : byte;  FillChr : char ) : string;
var
    SLen1 : byte absolute s1;
    int1, int2 : integer;
    string1, string2, string3 : string;
    String1Len : byte absolute string1;

begin
  string1:=s1;  string2:=LeftRight ( s2, Len, FillChr, Left );  string3:='';
  if StartPos-1 > SLen1 then
                string1:=LeftRight ( s1, StartPos-1, FillChr, Left );

  if String1Len >= StartPos+Len-1 then int2:=String1Len
                                  else int2:=StartPos+Len-1;
  for int1:= 1 to int2 do
     if int1 < StartPos then
                  Insert ( string1 [int1], string3, int1 )
                        else
     if int1 IN [StartPos..StartPos+Len-1] then
                  Insert ( string2 [int1-StartPos+1], string3, int1 )
                        else
     if int1 >= StartPos+Len then
                  Insert ( string1 [int1], string3, int1 );

  OverStr:=string3;
end;
{  }

{  }
Function ReplStr ( s1 : string;  s2 : string;
                   s3 : string;  StartPos : byte ) : string;

var
    SLen2 : byte absolute s2;
    string1 : string;
    int1, int2 : integer;

begin
  string1:=s1;
  while True do begin
     int1:= IndexStr ( string1, s2, StartPos );
     if int1 <= 0 then begin ReplStr:=string1; Exit end;
     Delete ( string1, int1, SLen2 );  Insert ( s3, string1, int1 );
                end;
end;
{  }

{  }
Function ReverseStr ( s : string ) : string;

var
    SLen : byte absolute s;
    string1 : string;
    int1 : integer;

begin
  string1:='';
  for int1:=1 to SLen do
            Insert ( s [SLen-int1+1], string1, int1 );
  ReverseStr:=string1;
end;
{  }

{  }
  function WordCount(S : string; WordDelims : CharSet) : Byte;
    {-Given a set of word delimiters, return number of words in S}
  var
    I, Count : Byte;
    SLen : Byte absolute S;
  begin
    Count := 0;
    I := 1;

    while I <= SLen do begin
      {skip over delimiters}
      while (I <= SLen) and (S[I] in WordDelims) do
        Inc(I);

      {if we're not beyond end of S, we're at the start of a word}
      if I <= SLen then
        Inc(Count);

      {find the end of the current word}
      while (I <= SLen) and not(S[I] in WordDelims) do
        Inc(I);
    end;

    WordCount := Count;
  end;
{  }

{  }
  function ExtractWord(N : Byte; S : string; WordDelims : CharSet) : string;
    {-Given a set of word delimiters, return the N'th word in S}
  var
    I, Count, Len : Byte;
    SLen : Byte absolute S;
  begin
    Count := 0;
    I := 1;
    Len := 0;
    ExtractWord[0] := #0;

    while (I <= SLen) and (Count <> N) do begin
      {skip over delimiters}
      while (I <= SLen) and (S[I] in WordDelims) do
        Inc(I);

      {if we're not beyond end of S, we're at the start of a word}
      if I <= SLen then
        Inc(Count);

      {find the end of the current word}
      while (I <= SLen) and not(S[I] in WordDelims) do begin
        {if this is the N'th word, add the I'th character to Tmp}
        if Count = N then begin
          Inc(Len);
          ExtractWord[0] := Char(Len);
          ExtractWord[Len] := S[I];
        end;

        Inc(I);
      end;
    end;
  end;
{  }

{  }
function WordLength ( n : byte;  s : string;  WordDelims : CharSet ) : integer;
begin
  WordLength := Length ( ExtractWord ( n, s, WordDelims ) );
end;
{  }

{  }
Function WordIndex ( n : byte;  s : string;  WordDelims : CharSet ) : integer;

var
    Count : Byte;
    SLen : Byte absolute s;
    int1 : integer;

begin
    Count := 0;
    int1 := 1;

    while (int1 <= SLen) AND (Count<>n) do begin
      while (int1 <= SLen) and (s [int1] in WordDelims) do
        Inc (int1);

      if int1 <= SLen then   Inc (Count);
      
      if Count = n then begin  WordIndex:=int1; Exit;  end;

      while (int1 <= SLen) and not(s [int1] in WordDelims) do
        Inc (int1);
                                           end;

    WordIndex:=0;
  end;
{  }

{  }
Function SubWords ( StartWord : byte;  NumWords : byte;
                   s : string;  WordDelims : CharSet ) : string;

var
    int1, int2 : integer;

begin
  SubWords:='';

  {  ࢮ ᫮, 室 ᫨ ᫮   }  
  int1:=WordIndex ( StartWord, s, WordDelims );  
  if int1=0 then Exit;

  {  ᫥ ᫮; ᫨ ᫮  ,   ப   }  
  int2:=WordIndex ( StartWord+NumWords, s, WordDelims );
  if int2=0 then int2:=Length (s)+1;

  { 祭  ⢠ ᫮ (   ப)              }
  SubWords:=Copy ( s, int1, int2-int1 );
end;
{  }

{  }
function ByteToChar ( B : Byte ) : Char;

var
    C : Char absolute B;

begin
  ByteToChar := C;
end;
{  }

{  }
function CharToByte ( C : Char ) : Byte;

var
    B : Byte absolute C;

begin
  CharToByte := B;
end;
{  }

end.
