{ EPRS.PAS                                                          }
{   EGA                                              }
{  :  ३ ⠫쥢                                   }
{          (0172) 27-29-37                                    }
{                      52-69-93                                    }
{  Turbo Pascal 5.5                                       }
{  ணࠬ ᯮ짮 unit ⮢ Turbo-Professional 5.11    }
{  Bonus (᫥ ࠢ int24.pas ਫ)              }

uses int24, tpcrt, tpstring, dos, tpedit ,tpdir, tppick;
{$I-}
const
     combFrame    : FrameArray = 'Ըͳ';
     doubleFrame  : FrameArray = 'Ȼͺ';
     singleFrame  : FrameArray = 'ĳ';

type
    paltype = array[0..15] of byte;

const
    standart : paltype=(0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);
Var
    palette  : paltype;
    beam     : byte;
    fname    : string;

Procedure SetPalReg(rno,rva:byte);
Var
   r : registers;
begin
  r.ah := $10;
  r.al := 0;
  r.bl := rno;
  r.bh := rva;
  Intr($10,r);
end;

Procedure SetPalette;
Var
   k : byte;
begin
  for k:=0 to 15 do SetPalReg(k,palette[k]);
end;


Procedure GetPalReg(rno:byte);
Var
   r : registers;
begin
  r.ah := $10;
  r.al := $7;
  r.bl := rno;
  Intr($10,r);
  palette[rno] := r.bh;
end;

Procedure GetPalette;
Var
   k : byte;
begin
  for k:=0 to 15 do GetPalReg(k);
end;


Procedure DrawMap(xc,yc:byte);
Var
   x,y : byte;

begin
FrameChars:=combFrame;
  For x:=0 to $F do
    For y:=0 to $7 do
      FastWrite(chr(254),yc+1+y,xc+1+x, (y*$10)+x);
  FrameWindow(xc,yc,xc+17,yc+9,$03,$0F,' Color map ');
end;

Procedure DrawSingle(xc,yc,color:byte; aktive:boolean);
Var
   nst : string;
   fcol : byte;
begin
  fcol:=$07;
  if aktive then begin
                 FrameChars:=doubleFrame;
                 fcol:=$03;
                 end
     else FrameChars:=singleFrame;

  nst:=Long2Str(color);
  if not aktive then nst:=nst+''
     else nst:=nst+'';
  FrameWindow(xc,yc,xc+4,yc+3,fcol,fcol,nst);
  FastWrite('',yc+1,xc+1,color);
  FastWrite('',yc+2,xc+1,color);

 if aktive then FastWrite('',yc+3,xc+2,fcol);
end;

Function Color2String(color:byte):string;
Var s:string;
begin
s:='';
  Case color of
   0 : s:='Black';
   1 : s:='Blue';
   2 : s:='Green';
   3 : s:='Cyan';
   4 : s:='Red';
   5 : s:='Magenta';
   6 : s:='Brown';
   7 : s:='White';
   8 : s:='Gray';
   9 : s:='Light blue';
  10 : s:='Light green';
  11 : s:='Light cyan';
  12 : s:='Light red';
  13 : s:='Light magenta';
  14 : s:='Yellow';
  15 : s:='Light white';
  end;
Color2String:=s;
end;

Procedure DrawTests(x,y,c:byte);
Var
   xp,k : byte;
begin
  xp:=x;
  For k:=0 to 7 do
      begin
       FastWrite('  Test  ',y,xp,(c*$10)+k);
       inc(xp,7);
      end;
  xp:=x;
  For k:=8 to $F do
      begin
       FastWrite('  Test  ',y+1,xp,(c*$10)+k);
       inc(xp,7);
      end;
end;

Function NumBars(current,bm:byte):byte;
Var
   rval:byte;
begin
 rval:=0;
 Case bm of
  1 : begin
        if (palette[current] and 4) = 4 then inc(rval,2);
        if (palette[current] and 32) = 32 then inc(rval);
      end;
  2 : begin
        if (palette[current] and 2) = 2 then inc(rval,2);
        if (palette[current] and 16) = 16 then inc(rval);
      end;
  3 : begin
        if (palette[current] and 1) = 1 then inc(rval,2);
        if (palette[current] and 8) = 8 then inc(rval);
      end;
 end;
 NumBars:=rval*8;
end;


Procedure DrawRegs(xc,yc,current:byte);
begin
   FrameChars:=doubleFrame;
   FrameWindow(xc+1,yc+5,xc+1+40,yc+6+6,$03,$0F,' Register : '+Color2String(current)+' ');
   FastVert('',yc+5,xc,$03);
   FastWrite('',yc+9,xc,$03);

   FastWrite('Ķ',yc+6,xc+1,$03);
   FastWrite('  Red                                ',yc+7,xc+1,$03);
   FastWrite('Ķ',yc+8,xc+1,$03);
   FastWrite('  Green                              ',yc+9,xc+1,$03);
   FastWrite('Ķ',yc+10,xc+1,$03);
   FastWrite('  Blue                               ',yc+11,xc+1,$03);
   FastWrite('',yc+12,xc+1,$03);
   FastWrite(CharStr('',NumBars(current,1)),yc+7,xc+12,$4c);
   FastWrite(CharStr('',NumBars(current,2)),yc+9,xc+12,$2a);
   FastWrite(CharStr('',NumBars(current,3)),yc+11,xc+12,$19);
   FastWrite(Pad(Long2Str((NumBars(current,1)*100) div 24)+'%',4),yc+7,xc+37,$03);
   FastWrite(Pad(Long2Str((NumBars(current,2)*100) div 24)+'%',4),yc+9,xc+37,$03);
   FastWrite(Pad(Long2Str((NumBars(current,3)*100) div 24)+'%',4),yc+11,xc+37,$03);
   Case beam of
     1 : FastWrite('Red',yc+7,xc+3,$0f);
     2 : FastWrite('Green',yc+9,xc+3,$0f);
     3 : FastWrite('Blue',yc+11,xc+3,$0f);
   end;

end;

Procedure DrawColors(xc,yc,current:byte);
Var
   posx,k  : byte;
   lstr    : string;
begin

  posx :=0;
  For k:=0 to $F do
      begin
      DrawSingle(xc+posx,yc,k,(k=current));
      if k=current then
         begin
           FastWrite(CharStr(' ',80),yc+4,1,0);
          lstr :=''+CharStr('',posx+1)+'';
          FastWrite(lstr,yc+4,1,$03);
         end;
      inc(posx,5);
      end;

   DrawRegs(xc,yc,current);

   FrameWindow(xc,yc-5,xc+58,yc-2,$03,$0f,' Test ');
   DrawTests(xc+1,yc-4,current);
end;

Procedure DisplayAll(curcol,curbeam:byte);
begin
  beam := curbeam;
  SetPalette;
  DrawColors(1,13,curcol);
end;

Procedure IncBeam(col,beam:byte);
Var
   v : byte;
begin
  v:=0;
  Case beam of
   1 : begin
         if (palette[col] and 32) = 32 then v:=v+4;
         if (palette[col] and 4) = 4 then v:=v+32;
         Case v of
           32 : palette[col]:= palette[col] or 32;
           4  : begin
                palette[col]:= (palette[col] or 4) and (not 32);
                end;
           0  : palette[col]:= palette[col] or 32;
         end;
       end;

   2 : begin
         if (palette[col] and 16) = 16 then v:=v+2;
         if (palette[col] and 2) = 2 then v:=v+16;
         Case v of
           16 : palette[col]:= palette[col] or 16;
           2  : palette[col]:= (palette[col] or 2) and (not 16);
           0  : palette[col]:= palette[col] or 16;
         end;
       end;

   3 : begin
         if (palette[col] and 8) = 8 then v:=v+1;
         if (palette[col] and 1) = 1 then v:=v+8;
         Case v of
           8  : palette[col]:= palette[col] or 8;
           1  : palette[col]:= (palette[col] or 1) and (not 8);
           0  : palette[col]:= palette[col] or 8;
         end;
       end;
  end;
  DrawRegs(1,13,col);
  SetPalReg(col,palette[col]);

end;


Procedure DecBeam(col,beam:byte);
Var
   v : byte;
begin
  v:=0;
  Case beam of
   1 : begin
         if (palette[col] and 32) = 32 then v:=v+4;
         if (palette[col] and 4) = 4 then v:=v+32;
         Case v of
           36  : palette[col]:= palette[col] and (not 32);
           32  : palette[col]:= (palette[col] or 32) and (not 4);
           4   : palette[col]:= palette[col] and (not 32);
         end;
       end;

   2 : begin
         if (palette[col] and 16) = 16 then v:=v+2;
         if (palette[col] and 2) = 2 then v:=v+16;
         Case v of
           18  : palette[col]:= palette[col] and (not 16);
           16  : palette[col]:= (palette[col] or 16) and (not 2);
           2   : palette[col]:= palette[col] and (not 16);
         end;
       end;

   3 : begin
         if (palette[col] and 8) = 8 then v:=v+1;
         if (palette[col] and 1) = 1 then v:=v+8;
         Case v of
           9  : palette[col]:= palette[col] and (not 8);
           8  : palette[col]:= (palette[col] or 8) and (not 1);
           1  : palette[col]:= palette[col] and (not 8);
         end;
       end;
  end;
  DrawRegs(1,13,col);
  SetPalReg(col,palette[col]);

end;


Function GetAdapter:string;
Var
   s: string;
begin
  s:='Unknown';
  Case CurrentDisplay of
    MonoHerc : s:='Hercules';
    CGA      : s:='CGA';
    MCGA     : s:='MCGA';
    EGA      : s:='EGA';
    VGA      : s:='VGA';
    PGC      : s:='PGC';
  end;
  GetAdapter:=s;
end;

Procedure DrawInfo;
begin
  FastWrite(CenterCh(' EGA palette registers service. Copyright (C) Fsoft 1992 by Bogush A.V. ','',80),1,1,$04);
  FrameWindow(1,2,59,7,$03,$0f,' Info ');
   FastWrite(
 ','+chr(26)+'-change color.,-change beam. F5-reset default value.',3,2,7);
 FastWrite(
 'Gray+/Gray- - controls beam intensity. F2/F3 - save/load.'
 ,4,2,7);
 FastWrite(Pad('Esc - quit.',57),5,2,7);
 FastWrite(CharStr(' ',57),6,2,$00);
 FastWrite('Adapter : ',6,2,$03);
 FastWrite(GetAdapter,6,12,$0f);
 FastWrite('FileName : ',6,25,$03);
 FastWrite(JustFileName(fname),6,36,$0f);
end;

Procedure SaveFile;
Var
   f:file of byte;
   mask : string;
   Esc  : boolean;
   k    : byte;
begin
  mask:=fname;
  if mask='--------' then mask:='palette.ega';

  ReadString('FileName to save :',6,2,38,$0f,$1f,$0c,Esc,mask);
  if not Esc then
     begin
       fname:=mask;
       Assign(f,fname);
       Rewrite(f);
       k:=ord('E');
       Write(f,k);
       for k :=0 to 15 do Write(f,palette[k]);
       Close(f);
     end;
  DrawInfo;
end;

Procedure LoadFile;
const
     GFC : PickColorArray = ($70,$71,$7E,$30,$71,$31,$78);
Var
   f:file of byte;
   mask : string;
   Esc  : boolean;
   k    : byte;
begin
  mask:=fname;
  if mask='--------' then mask:='*.ega';

  ReadString('FileName to load :',6,2,38,$0f,$1f,$0c,Esc,mask);
  if not Esc then
     begin
       if (GetFileName(mask,AnyFile,10,10,20,3,GFC,
          fname)<>0) or (fname='') then begin
                         fname:='--------';
                         DrawInfo;
                         Exit;
                         end;
       Assign(f,fname);
       Reset(f);
       Read(f,k);
       if chr(k)='E' then for k:=0 to 15 do  Read(f,palette[k])
          else begin
               FastWrite('Error in file...',6,36,$4E);
               Sound(2000);
               Delay(100);
               NoSound;
               Delay(1000);
               fname:='--------';
               end;

       Close(f);
     end;
  SetPalette;
  DrawInfo;
end;

Procedure MainLoop;
Var
   col,bm : byte;
   done   : boolean;
   key    : word;
begin
   col:=0;
   bm:=1;
   DisplayAll(col,bm);
   done :=false;
   key :=0;
   While not done do
     begin
       key:=ReadKeyWord;
       Case key of
         $011b : done:=true; {esc}

         $4d00 : begin
                 if col<15 then inc(col)    {left}
                    else col:=0;
                 DrawColors(1,13,col);
                 end;

         $4b00 : begin
                 if col>0 then dec(col)      {right}
                    else col:=15;
                 DrawColors(1,13,col);
                 end;

         $4800 : begin
                 if bm>1 then dec(bm)        {up}
                    else bm:=3;
                 beam:=bm;
                 DrawRegs(1,13,col);
                 end;

         $5000 : begin
                 if bm<3 then inc(bm)        {down}
                    else bm:=1;
                 beam:=bm;
                 DrawRegs(1,13,col);
                 end;

         $4a2d : DecBeam(col,bm);             {-}

         $4e2b : IncBeam(col,bm);             {+}

         $3f00 : begin
                 palette[col]:=standart[col];
                 DrawRegs(1,13,col);
                 SetPalette;
                 end;

         $3c00 : SaveFile;

         $3d00 : begin
                 LoadFile;
                 DrawRegs(1,13,col);
                 end;

       end;
     end;
end;


begin
 TextColor(7);
 TextBackGround(0);
 ClrScr;
 HiddenCursor;
 fname:='--------';
 SetBlink(false);
 if (CurrentDisplay=VGA) or (CurrentDisplay=PGC) then GetPalette
    else palette:=standart;
 beam := 1;
 SetPalette;
 DrawInfo;
 DrawMap(63,2);
 Mainloop;
 TextColor(7);
 TextBackGround(0);
 ClrScr;
 SetBlink(true);
 NormalCursor;
end.