#pragma inline
#include <alloc.h>
#include <string.h>
#include "edstr.h"
/* 㭪  ।஢  
    ࠧ ப ࠭祭 ,
   ᤢ   / ࠢ   室
   ப  ࠬ . 㭪 頥
   ।஢ ப  ⮬  , 
   ஬  뫠 ।.
   ࠬ:
   row       -  ப   ࠭;
   start_col -  न   ࠭;
   end_col   - ࠢ न   ࠭;
   cursorshape - ଠ ;
   buffersize - ࠧ  ப, ;
   originalstring - 㪠⥫  ।㥬
		     ப;
   sourceattr - 㪠⥫  ப ਡ⮢
		  訢  ;
   destattr - 㪠⥫   ਡ⮢ ;
    ᨢ sourceattr[]  destattr[]
     ࠢ (end_col - start_col - 2).
   㭪 頥 ப */

char *edit_string(int row,int start_col,
		  int end_col,int cursorshape,int buffersize,
		  char *originalstring,unsigned char *sourceattr,
		  unsigned char *destattr){
 int ch;
 /* 砫쭠  筠 न ப  ࠭, ਭ  */
 int startcolumn,endcolumn,width;
 /*  室 ப  ࠬ  */
 int beg_status,end_status;
 /* ⥪  ப,  ⪠ ப
    ࠢ   */
 int length,rest;
 char *buffer;   /*   ।஢ */
 int entry;      /*  宦  横 */
 /*  ࠬ : x  y न
     ଠ  */
 unsigned long cursorparms;
 int cursorpos_w;   /*     */
 /* 㪠⥫     ப */
 char *cursorpos_s;

 /* १ࢨ஢   ।஢
    ப ࠧ buffersize */
 if ((buffer = malloc(buffersize)) == NULL)
   return 0;

 /* ࠭  ࠬ  */
 cursorparms = get_cursor_position_size();

 /* ᫨ ஬ 祭 */
 startcolumn = start_col + 1;
 endcolumn = end_col - 1;
 width = end_col - startcolumn;
 /* ᨬ쭠  ப */
 buffersize--;
 /* ᪮஢ ப     
    ,  砫쭮 祭 ⪠ */
 length = string_copy(buffer,originalstring);
 rest = 0;

 /* 砫쭮    ப - 
     ப, .. ࠢ  */
 cursorpos_s = buffer + length;
 end_status = 0;

 /* ।     
    祭   */
 if (length < width) {
   cursorpos_w = startcolumn+length;
   beg_status = 0;
 } else {
   cursorpos_w = endcolumn;
   beg_status = 1;
 }
 /* 뢥 ப  ࠭ */
 asm call near ptr updateleft
 /*  ப ਡ⠬ *sourceattr 
    樨 ।஢ ப */
 if (length)
   make_hbar(row,startcolumn,cursorpos_w -
	     startcolumn,sourceattr,destattr);
 /* ⠭   㦭  */
 set_cursor_position(cursorpos_w,row);
 /* ⠭   */
 set_cursor_size(cursorshape);
 entry = 0;       /* 㫥 宦  横 */

key_loop:
 /*     */
 switch(ch = getkey()) {
  case TAB:       /*   TAB */
    goto E_nter;
  case ESCAPE:       /*   ESCAPE */
    free(buffer);
 /* ⠭ ࠬ  */
    set_cursor_position_size(cursorparms);
    return(NULL);    /* ३    NULL*/
  case ENTER:        /*   ENTER */
    /* ८ࠧ ।஢ ப 
       孨 ॣ  ᪮஢  
       ࢮ砫  */
E_nter:
    strcpy(originalstring,buffer);
 /* 뢥 ८ࠧ ப  ࠭ */
    asm call near ptr updateleft
    goto quit;       /* ३   */
  case HOMEKEY:      /*   Home */
    /* ᫨ 㫥 宦,  ⠭
       ਡ ࠭ */
    if (!entry) {
      if (length)
	asm call near ptr restorebar;
      entry = 1;
    }
    if (rest != length) {
      cursorpos_w = startcolumn;
      cursorpos_s = buffer;
      rest = length;
      beg_status = 0;
      end_status = (rest <= width) ? 0 : 1;
      /*  ப ࠢ */
      asm call near ptr updateright
      break;
    } else
      goto key_loop;
  case PGUPKEY:      /*   PgUp */
    if (!entry) {
      if (length)
	asm call near ptr restorebar;
      entry = 1;
    }
    length = rest = string_copy(buffer,
				originalstring);
    cursorpos_w = startcolumn;
    cursorpos_s = buffer;
    beg_status = 0;
    end_status = (length <= width) ? 0 : 1;
    clear_nchars(row,startcolumn,width);
    asm call near ptr updateright
    break;
  case LEFTKEY:      /*  ५  */
    if (!entry) {
      if (length)
	asm call near ptr restorebar;
      entry = 1;
    }
    if (cursorpos_w > startcolumn) {
      cursorpos_w--;
      cursorpos_s--;
      rest++;
      break;
    } else {
      if (rest < length) {
	cursorpos_s--;
	rest++;
	beg_status = (rest == length) ? 0 : 1;
	end_status = (rest <= width) ? 0 : 1;
	asm call near ptr updateright
      }
      goto key_loop;
    }
  case ENDKEY:       /*   END */
    if (!entry) {
      if (length)
	asm call near ptr restorebar;
      entry = 1;
    }
    if (rest) {
      cursorpos_s = buffer + length;
      end_status = 0;
      rest = 0;
      if (length < width) {
	cursorpos_w = startcolumn + length;
	beg_status = 0;
      } else {
	cursorpos_w = endcolumn;
	beg_status = 1;
      }
      /*  ப  */
      asm call near ptr updateleft
      break;
    } else
      goto key_loop;
  case RIGHTKEY:     /*  ५ ࠢ */
    if (!entry) {
      if (length)
	asm call near ptr restorebar;
      entry = 1;
    }
    if (cursorpos_w < endcolumn) {
      if (rest) {
	cursorpos_w++;
	cursorpos_s++;
	rest--;
	break;
      }
      goto key_loop;
    } else {
      if (rest) {
	cursorpos_s++;
	rest--;
	beg_status=((length-rest)<width) ? 0 : 1;
	end_status = (rest<=1) ? 0 : 1;
	asm call near ptr updateleft
      }
      goto key_loop;
    }
  case DELKEY:       /*   DELETE */
    if (!entry) {
      if (length)
	asm call near ptr restorebar;
      entry = 1;
    }
    if (rest) {
      delete_char(cursorpos_s,rest);
      rest--;
      length--;
      if (rest < endcolumn-cursorpos_w) {
	end_status = 0;
	if (beg_status) {
	  cursorpos_w++;
	  beg_status = (length-rest <
		 cursorpos_w-start_col) ? 0 : 1;
	  asm call near ptr updateleft
	  break;
	}
	asm call near ptr updateright
      } else {
	end_status = (rest <=
		   end_col-cursorpos_w) ? 0 : 1;
	asm call near ptr updateright
      }
    }
    goto key_loop;
  case BACKSPACE: /*   BACKSPACE */
    if (!entry) {
      if (length)
	asm call near ptr restorebar;
      entry = 1;
    }
    if (rest < length) {
      cursorpos_s--;
      delete_char(cursorpos_s,rest+1);
      length--;
      if (rest < end_col-cursorpos_w) {
	end_status = 0;
	if (beg_status) {
	  beg_status = (length-rest <
		 cursorpos_w-start_col) ? 0 : 1;
	  asm call near ptr updateleft
	} else {
	  cursorpos_w--;
	  asm call near ptr updateright
	  break;
	}
      } else {
	if (cursorpos_w > startcolumn) {
	  cursorpos_w--;
	  end_status = (rest <=
		   end_col-cursorpos_w) ? 0 : 1;
	  asm call near ptr updateright
	  break;
	} else {
	  if (rest == length) {
	    beg_status = 0;
	    asm call near ptr updateright
	  }
	}
      }
    }
    goto key_loop;

  default:           /*  ⠫  */
    /* ᫨  "" , 
         横 */
    if (ch<32 || ch>255)
      goto key_loop;
    if (!entry) {   /* ᫨ 㫥 宦 */
      if (length)
	asm call near ptr restorebar;
      *buffer = 0;
      length = rest = beg_status = end_status = 0;
      cursorpos_s = buffer;
      cursorpos_w = startcolumn;
      entry = 1;
      /*  ப  ࠭ */
      clear_nchars(row,start_col,
		   end_col-start_col+1);
      set_cursor_position(startcolumn,row);
    }
    /* ᫨  ,   横 */
    if (length >= buffersize)
      goto key_loop;
    /* ⠢ ᨬ  ப */
    insert_char(cursorpos_s,rest,ch);
    length++;
    if (cursorpos_w < endcolumn) {
      end_status = (rest <
		   end_col-cursorpos_w) ? 0 : 1;
      asm call near ptr updateright
      cursorpos_s++;
      cursorpos_w++;
      break;
    }
    cursorpos_s++;
    beg_status = (length-rest <
		 cursorpos_w-start_col) ? 0 : 1;
    asm call near ptr updateleft
    goto key_loop;
 }
 /* ⠭   㦭  */
 set_cursor_position(cursorpos_w,row);
 goto key_loop;

quit:
 free(buffer);
 /* ⠭ ࠬ  */
 set_cursor_position_size(cursorparms);
 return(originalstring);
 /* 楤 ஥ ᥬ
    楤 ⠭ ਡ⮢
    襭 ᪠ */
 asm restorebar proc near
  make_hbar(row,startcolumn,cursorpos_w -
	       startcolumn,destattr,sourceattr);
 asm ret
 asm restorebar endp

 /* 楤  ப ࠢ */
 asm updateright proc near
 update_right(row,startcolumn,endcolumn,
	      beg_status,end_status,
	      cursorpos_w,cursorpos_s);
 asm ret
 asm updateright endp

 /* 楤  ப  */
 asm updateleft proc near
 update_left(row,startcolumn,endcolumn,
	     beg_status,end_status,
	     cursorpos_w,cursorpos_s);
 asm ret
 asm updateleft endp
}
