/**
*  , ন騩 ࠡ  ⠪ 뢠 pop-.
*
* 	3.5	(C)Copyright InfoScope Inc. 1991
*
**/

#include <ctype.h>

#include "mn_pop.h"

/**
*
* 	mn_makePop	--  ࠡ  pop-
*
* 饭     pmenu = mn_makePop(pdef, pupper_left);
*
* ࠬ:    MN_POP 	     *pmenu	頥 㪠⥫ 
*					ᮧ  
*					NULL, ᫨  墠⨫ .
*		MN_POP_DEF   *pdef	⥫  ,
*					뢠 pop-.
*		LOC 	  *pupper_left	⥫  ,
*					    ࠭.
*
* ᠭ	㭪 ᮧ    室 .
*		᫨  -    墠⠥ , 
*		࠭ p饭  ᢮  뢠
*		⥬ 㭪 wnd_Err  ࠬ஬ MN_OUT_OF_MEMORY.
*
* 頥	pmenu	⥫  ᮧ  
*			NULL, ᫨  墠⨫ .
*
* 뢠 ᫥騥 㭪樨 ⥬:
*
* 	3.5	(C)Copyright InfoScope Inc. 1991
*
**/

ENTRY MN_POP_PTR mn_makePop(MN_POP_DEF *pdef, LOC *pupper_left)
{
   MN_POP_PTR	pmenu;
   LOC        	where={0,0};

   if((pmenu=utl_alloc(MN_POP)) == NULL) {      /*      */
      (*mn_Err)(MN_OUT_OF_MEMORY);
      return NULL;
   }
   if((mn_SetInPop(pmenu)=mn_MakeSet()) == NULL) {/*  		*/
      utl_free(pmenu);
      (*mn_Err)(MN_OUT_OF_MEMORY);
      return NULL;
   }
		/*  ,  ஬ 㤥 뢠 	*/
   if(pupper_left != NULL)
      where = *pupper_left;
   if((mn_HoleInPop(pmenu)=mn_CreateHole(&(pdef->hole),&where)) == NULL) {
   						/*    	*/
      utl_free(mn_SetInPop(pmenu));
      utl_free(pmenu);
      (*mn_Err)(MN_OUT_OF_MEMORY);
      return NULL;
   }
				   /*   浪 - ⠭ 	*/
   pmenu->last_key  = 0;
   pmenu->current   = pdef->current;
   pmenu->protected = pdef->protected;
   pmenu->selected  = pdef->selected;
   pmenu->pick_out  = pdef->pick_out;

   return pmenu;				/* ᯥ	*/

}/*mn_makePop*/

/**
*
* 	disposePopField --	᢮  㭪 pop-
*
* 饭	disposePopField(pitem);
*
* ࠬ:	MN_ITEM_PTR pitem	⥫  ᢮ 㭪.
*
* ᠭ  	᫨ ᮮ⢥騥 㪠⥫  ࠢ NULL, ,
*		   㪠뢠, ᢮.
*
* 頥	void	頥 祭 .
*
* 뢠 ᫥騥 㭪樨 ⥬:
*
* 	3.5	(C)Copyright InfoScope Inc. 1991
*
**/

ENTRY void disposePopField(MN_ITEM_PTR pitem)
{
   if(mn_PopFields(pitem)) {
       if(mn_PopItemName(pitem))
          utl_free(mn_PopItemName(pitem));
       if(mn_PopItemKeys(pitem))
          utl_free(mn_PopItemKeys(pitem));
       if(pitem->link)
          utl_free(pitem->link);
   }
}/*disposePopField*/

/**
*
* 	mn_disposePopItem	-- ⮦ 㭪 pop-
*
* 饭	result = mn_disposePopItem(pmenu,ident);
*
* ࠬ:    byte 	     result	 ࠢ 1, ᫨
*					  浪,  0.
*		MN_POP_PTR pmenu	, ஬ ਭ
*					㤠塞 㭪.
*		unsigned     ident	䨪 㤠塞 㭪.
*
* ᠭ	맮 㭪樨  mn_DisposeItem(), ன ।
*		 窨 室  disposePopField(), ᢮
*		㭪   䨪஬.
*
* 頥	result	1, ᫨ 㤠 諮, 0  砥 訡.
*
* 뢠 ᫥騥 㭪樨 ⥬:
*
*     3.5    (C)Copyright InfoScope Inc. 1991
*       mn_DisposeItem(), disposePopField(),
*
**/

ENTRY byte mn_disposePopItem(MN_POP_PTR pmenu,unsigned ident)
{
   return mn_DisposeItem(mn_SetInPop(pmenu),ident,disposePopField);
}/*mn_disposePopItem*/

/**
*
* 	mn_disposePop	-- ⮦ pop-
*
* 饭	mn_disposePop(MN_POP_PTR pmenu);
*
* ࠬ:	MN_POP_PTR pmenu
*
* ᠭ	맮 㭪樨  mn_DisposeSet(), ன ।
*		 窨 室  disposePopField(), ᫥⥫쭮
*		᢮   㭪⮢.
*		᫥ ⮣ ᢮ , ⢥   
*		ᠬ  .
*
* 頥	void	頥 祭 .
*
* 뢠 ᫥騥 㭪樨 ⥬:
*       mn_DisposeSet(), mn_disposePopField(),
*       mn_DisposeHole(), utl_free()
*
*     3.5    (C)Copyright InfoScope Inc. 1991
*
**/

ENTRY void mn_disposePop(MN_POP_PTR pmenu)
{
   if(pmenu != NULL) {
       mn_DisposeSet(mn_SetInPop(pmenu),NULL,disposePopField);
       mn_DisposeHole(mn_HoleInPop(pmenu));      /*  㡥६            */
       utl_free(pmenu);			/*  ⤠ 		*/
   }
}/*mn_disposePop*/


/**
*
*    mn_addPopItem --  㭪  ⠭  
*
* 饭     result = mn_addPopItem(pmenu, ident, pdef);
*
* ࠬ:	int result	  1, ᫨   浪,
*				  0  ⨢ 砥
*               MN_POP_PTR pmenu   ⥫  pop-
*		unsigned ident	  䨪 㭪.
*		MN_POP_ITEM_DEF *pdef  ⥫  , ᮤঠ
*				  ᠭ 㭪.
*
* ᠭ      ᫨ -㭪   䨪஬   ,
*               㭪    . ᫥ ⮣  ⠭
*                㭪, 訢 室 .
*                㪠  ப keys  ᨬ 
*               ᯮ ᨬ '\xFF',   ᫥ ᪥-.
*               ਬ, "\xFF\x3B" 砥,    F1.
*
*               ᫨   墠⠥, 㭪 㭨⮦ 㭪 
*		頥 0.
*		ଠ, ᯥ筠  pop-, "訢"
*		  link ᭮ 㭪 .
*
* 頥	result	1, ᫨   浪,
*			0  ⨢ 砥
*
* 뢠 ᫥騥 㭪樨 ⥬:
*
*     3.5    (C)Copyright InfoScope Inc. 1991
*
**/

ENTRY MN_ITEM *mn_addPopItem(MN_POP_PTR pmenu, unsigned ident,
			MN_POP_ITEM_DEF *pdef, int pickInName)
{
   MN_ITEM_PTR	pitem;
   char		*lB;
   int 		lR;

   if(!pmenu || ident == 0)
      return 0;

   pitem = mn_GetItemPtr(mn_SetInPop(pmenu), ident);
   if(!pitem) {				/* ᫨ 㭪   ᮧ,	*/
      					/*  ᭠砫 ᮧ . 	*/
      pitem = mn_AddItem(mn_SetInPop(pmenu),ident,0,0,0);
      if(!pitem)
         return NULL;                   /* , ᮧ  㤠!  	*/
   }

   if((pitem->link = utl_alloc(MN_POP_FIELD)) == NULL) {
      mn_DisposeItem(mn_SetInPop(pmenu),ident,NULL);
      return NULL;		/*    pop-ଠ樨!	*/
   }
   if((mn_PopItemName(pitem)=x_calloc(1,pdef->width+1)) == NULL) {
      utl_free(pitem->link);
      mn_DisposeItem(mn_SetInPop(pmenu),ident,NULL);
      return NULL;
   }
   mn_PopPickInName(pitem) = pickInName;
   if(pdef->name && *pdef->name) {	/* ⨬   㭪	*/
      if ((lB=strchr(pdef->name,'{')) != NULL) {     /* 뤥 㪢?	*/
         lR = (int)(lB-pdef->name);		     /*   ?	*/
         if(*(lB+2) != '}') {	/*  뢠饩 ᪮ - 訬 	*/
            utl_free(pitem->link);
            utl_free(mn_PopItemName(pitem));
            mn_DisposeItem(mn_SetInPop(pmenu),ident,NULL);
            return NULL;
         }
         		/*  ᪮㥬  -  	*/
         strncpy(mn_PopItemName(pitem),pdef->name,min(pdef->width,lR));
         strncat(mn_PopItemName(pitem),lB+1,1);
         strncat(mn_PopItemName(pitem),lB+3,pdef->width-lR-1);
         mn_PopPickInName(pitem) = lR;
      }
      else
         strncpy(mn_PopItemName(pitem),pdef->name,pdef->width);
      *(mn_PopItemName(pitem)+pdef->width) = 0;	  /*  直 	*/
   }
   if(pdef->keys && *pdef->keys) /*  -  "樮"  */
      if((mn_PopItemKeys(pitem) = utl_strdup(pdef->keys)) == NULL) {
         mn_DisposeItem(mn_SetInPop(pmenu),ident,disposePopField);
         return NULL;
      }
				/* ᫥ 㤠 -   ਭ	*/
   mn_ItemLoc(pitem) = pdef->loc;
   mn_SetItemWidth(pitem,pdef->width);

   return pitem;

}/*mn_addPopItem*/

/**
*
* 	mn_showPopItem	--  㭪 pop-  
*
* 饭     mn_showPopItem(pmenu, pitem);
*
* ࠬ:    MN_POP_PTR pmenu	⥫   pop-.
*		MN_ITEM_PTR pitem	⥫  ॡ㥬 㭪.
*
* ᠭ	᫨  ࠭ 㭪 室  , 뢮
*                㭪.
*
*
* 頥	void	頥 祭 .
*
* 뢠 ᫥騥 㭪樨 ⥬:
*
* 	3.5	(C)Copyright InfoScope Inc. 1991
*
**/

ENTRY void mn_showPopItem(MN_POP_PTR pmenu, MN_ITEM_PTR pitem)
{
   LOC  loc;
   int  len,inHole;
   char *pn;
   int fore, back;

   inHole = mn_ItemVisible(mn_HoleInPop(pmenu),pitem);
   if(inHole) {
                                /* 砫 । 梥 fore  back  */
      fore = mn_itemIsProtected(pitem) ? pmenu->protected.fore :
      		mn_ItemIdent(mn_CurrentInSet(mn_SetInPop(pmenu))) ==
      						   mn_ItemIdent(pitem) ?
             pmenu->current.fore : -1;
      if(mn_itemIsSelected(pitem))	/*  ࠭ ਮ!	*/
         fore = pmenu->selected.fore;
      back = mn_itemIsSelected(pitem) ? pmenu->selected.back :
             mn_itemIsProtected(pitem) ? pmenu->protected.back : -1;
      if(mn_ItemIdent(mn_CurrentInSet(mn_SetInPop(pmenu))) ==
      						mn_ItemIdent(pitem))
         back = pmenu->current.back;	/* ਮ  ⥪饣!	*/
			/*  ⥯ - ᮡ⢥ 뢮	*/
      loc = mn_GetItemLocInHole(mn_HoleInPop(pmenu),pitem);
      len = strlen(pn = mn_PopItemName(pitem));
      if(len > mn_ItemWidth(pitem))
         len = mn_ItemWidth(pitem);
      len = min(len,inHole);
      if(len != 0)
         wnd_PutStr(mn_HolePane(mn_HoleInPop(pmenu)),&loc,pn,len,fore,back,0);

		/*  㦭   - 㪢?		*/
             	/*  ࠭ ᯮᮡ,   㭪 ⥪騬! */
      if(back != pmenu->current.back)
         back = pmenu->pick_out.back;
      if(mn_PopPickInName(pitem) != -1)
         wnd_PutChar(mn_HolePane(mn_HoleInPop(pmenu)),
                     utl_GetLoc(loc.x + mn_PopPickInName(pitem), loc.y),
                         pmenu->pick_out.fore, back,
                         *(pn+mn_PopPickInName(pitem)),0);
   }
}/*mn_showPopItem*/

/**
*
* 	mn_displayPop	--  pop-  
*
* 饭	result = mn_displayPop(pmenu);
*
* ࠬ:    int result  1, ᫨   浪,
*                           0, ᫨ -  ⠪  pmenu.
*		MN_POP_PTR pmenu	⥫ , ᮤঠ饩
*                           ଠ  pop-
*
* ᠭ      ஢ਢ , 頥  㭪樨
*               mn_showPopItem()   㭪⮬.
*
* 頥    result      1, ᫨   浪,
*                           0, ᫨ -  ⠪  pmenu.
*
* 뢠 ᫥騥 㭪樨 ⥬:
*      mn_FirstInSet(), mn_HoleOn(),
*        FOREACHmn_Item(), mn_showPopItem()
*
*     3.5    (C)Copyright InfoScope Inc. 1991
*
**/

ENTRY int mn_displayPop(MN_POP_PTR pmenu)
{
   MN_ITEM_PTR pitem;

   if(!pmenu)
      return 0;

   if(mn_FirstInSet(mn_SetInPop(pmenu)) == NULL)
      return 0;			/* 訡:   ⠭	*/

   mn_HoleOn(mn_HoleInPop(pmenu));

   FOREACHmn_Item(mn_SetInPop(pmenu),pitem) {
       mn_showPopItem(pmenu,pitem);
   }
   return 1;
}/*mn_displayPop*/


/**
*
*    mn_navPopKey   --  ᢮ ⨥
*
* 饭 pfound = mn_navPopKey(pset,key);
*
* ࠬ:    MN_ITEM *pfound   㭪, ᫨
*		 		 - ,
*				NULL, ᫨   .
*               MN_ITEM_SET *pset    , ᮤঠ饩
*                            	ଠ   㭪⮢ pop-
*               unsigned key     
*
* ᠭ      ।   ࠢ  묨
*               ᯥ樠묨 ᨬ 㭪⮢;  ᮢ
*               㪠⥫  㭪 頥.
*
* 頥	pfound	  㭪, ᫨
*		 	 - ,
*			NULL, ᫨   .
*
* 뢠 ᫥騥 㭪樨 ⥬:
*        FOREACHmn_Item(), mn_itemIsProtected(), POP_ITEM_KEYS()
*
*     3.5    (C)Copyright InfoScope Inc. 1991
*
**/

ENTRY MN_ITEM_PTR mn_navPopKey(MN_ITEM_SET *pset, unsigned key)
{
   MN_ITEM_PTR	pitem;
   char *pk,ch;
   int ext;

   FOREACHmn_Item(pset, pitem)
      if(!mn_itemIsProtected(pitem) &&
        (pk = mn_PopItemKeys(pitem)) != NULL)
          for(;*pk;pk++) {
             if((ext=(*pk == OxFF)) != 0)
                pk++;
             ch = (ext ? kbd_scan(key) : kbd_ascii(key));
             if(ch == *pk)
                return pitem;
          }

   return NULL;
}/*mn_navPopKey*/


