
CONST                                                 		{.CP08}
	{ ------------------------------------------- }
	{ Named Values for Bit Flags in RECORD CpuVec }
	{ ------------------------------------------- }

	_386Xtnsn = $80; _32BitMax = $40; _16BitMin = $20;
	_SignXtnd = $10; _MODrmFld = $08;

	O0 = Ord(C086); O1 = Ord(C186); O2 = Ord(C286); O3 = Ord(C386);

  Mnem386 : ARRAY[1..170] OF STRING[6] = (		{.CP32}

	{001}  'AAA',    'AAD',    'AAM',    'AAS',    'ADC',    'ADD',
	{007}  'AND',	 'ARPL',   'BOUND',  'BSF',    'BSR',	 'BT',
	{013}  'BTC',	 'BTR',	   'BTS',    'CALL',   'CBW',	 'CWDE',
	{019}  'CLC',	 'CLD',	   'CLI',    'CLTS',   'CMC',	 'CMP',
	{025}  'CMPSB',	 'CMPSW',  'CMPSD',  'CWD',    'CDQ',	 'DAA',
	{031}  'DAS',	 'DEC',	   'DIV',    'ENTER',  'HLT',	 'IDIV',
	{037}  'IMUL',	 'IN',	   'INC',    'INSB',   'INSW',	 'INSD',
	{043}  'INT',	 'INTO',   'IRET',   'JB',     'JBE',	 'JCXZ',
	{049}  'JECXZ',	 'JLE',	   'JMP',    'JNB',    'JNBE',	 'JNL',
	{055}  'JNLE',	 'JNO',	   'JNP',    'JNS',    'JNZ',	 'JO',
	{061}  'JP',	 'JS',	   'JZ',     'LAHF',   'LAR',	 'LDS',
	{067}  'LEA',	 'LEAVE',  'LES',    'LFS',    'LGDT',	 'LGS',
	{073}  'LIDT',	 'LLDT',   'LMSW',   'LOCK',   'LODSB',	 'LODSW',
	{079}  'LODSD',	 'LOOP',   'LOOPE',  'LOOPNE', 'LSL',	 'LSS',
	{085}  'LTR',	 'MOV',	   'MOVSB',  'MOVSW',  'MOVSD',	 'MOVSX',
	{091}  'MOVZX',	 'MUL',	   'NEG',    'NOP',    'NOT',	 'OR',
	{097}  'OUT',	 'OUTSB',  'OUTSW',  'OUTSD',  'POP',	 'POPA',
	{103}  'POPAD',	 'POPF',   'POPFD',  'PUSH',   'PUSHA',	 'PUSHAD',
	{109}  'PUSHF',	 'PUSHFD', 'RCL',    'RCR',    'REP',	 'REPNE',
	{115}  'RET',	 'RETF',   'ROL',    'ROR',    'SAHF',	 'SAR',
	{121}  'SBB',	 'SCASB',  'SCASW',  'SCASD',  'SEGCS',	 'SEGDS',
	{127}  'SEGES',	 'SEGFS',  'SEGGS',  'SEGSS',  'SETB',	 'SETBE',
	{133}  'SETL',	 'SETLE',  'SETNB',  'SETNBE', 'SETNL',	 'SETNLE',
	{139}  'SETNO',	 'SETNP',  'SETNS',  'SETNZ',  'SETO',	 'SETP',
	{145}  'SETS',	 'SETZ',   'SGDT',   'SHL',    'SHLD',	 'SHR',
	{151}  'SHRD',   'SIDT',   'SLDT',   'SMSW',   'STC',	 'STD',
	{157}  'STI',    'STOSB',  'STOSW',  'STOSD',  'STR',	 'SUB',
	{163}  'TEST',	 'VERR',   'VERW',   'WAIT',   'XCHG',	 'XLATB',
	{169}  'XOR',	 'JL');


   Mnem387 : ARRAY[1..76] OF STRING[7] = (			{.CP15}

	{01}  'F2XM1',  'FABS',   'FADD',   'FADDP',   'FBLD',   'FBSTP',
	{07}  'FCHS',   'FCLEX',  'FCOM',   'FCOMP',   'FCOMPP', 'FCOS',
	{13}  'FDECSTP','FDISI',  'FDIV',   'FDIVP',   'FDIVR',  'FDIVRP',
	{19}  'FENI',   'FFREE',  'FIADD',  'FICOM',   'FICOMP', 'FIDIV',
	{25}  'FIDIVR', 'FILD',   'FIMUL',  'FINCSTP', 'FINIT',  'FIST',
	{31}  'FISTP',  'FISUB',  'FISUBR', 'FLD',     'FLD1',   'FLDCW',
	{37}  'FLDENV', 'FLDG2',  'FLDL2E', 'FLDL2T',  'FLDN2',  'FLDPI',
	{43}  'FLDZ',   'FMUL',   'FMULP',  'FNOP',    'FPATAN', 'FPREM',
	{49}  'FPREM1', 'FPTAN',  'FRNDINT','FRSTOR',  'FSAVE',  'FSCALE',
	{55}  'FSETPM', 'FSIN',   'FSINCOS','FSQRT',   'FST',    'FSTCW',
	{61}  'FSTENV', 'FSTP',   'FSTSW',  'FSUB',    'FSUBP',  'FSUBR',
	{67}  'FSUBRP', 'FTST',   'FUCOM',  'FUCOMP',  'FUCOMPP','FXAM',
	{73}  'FXCH',   'FXTRACT','FYL2X',  'FYL2XP1');


	{ -------------------------------------------------- }	{.CP37}
	{ 386 Operations With One-Byte Op-Codes Handled Next }
	{ -------------------------------------------------- }

  GateLvl1 : ARRAY[0..255] of Gating = (

	{00}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{08}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_0Fx,
	{10}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{18}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{20}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Pfx, G_Hit,
	{28}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Pfx, G_Hit,
	{30}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Pfx, G_Hit,
	{38}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Pfx, G_Hit,
	{40}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{48}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{50}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{58}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{60}	G_Hit, G_Hit, G_Hit, G_Hit, G_Pfx, G_Pfx, G_Pfx, G_Pfx,
	{68}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{70}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{78}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{80}	G_RM1, G_RM1, G_ooo, G_RM1, G_Hit, G_Hit, G_Hit, G_Hit,
	{88}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{90}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{98}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{A0}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{A8}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{B0}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{B8}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{C0}	G_RM2, G_RM2, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{C8}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{D0}	G_RM2, G_RM2, G_RM2, G_RM2, G_Hit, G_Hit, G_ooo, G_Hit,
	{D8}	G_387, G_387, G_387, G_387, G_387, G_387, G_387, G_387,
	{E0}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{E8}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit,
	{F0}	G_Pfx, G_ooo, G_Pfx, G_Pfx, G_Hit, G_Hit, G_RM3, G_RM9,
	{F8}	G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_RM4, G_RM5);

	{ -------------------------------------------------- }	{.CP32}
	{ 386 Operations With Two-Byte Op-Codes Handled Next }
	{ -------------------------------------------------- }

   GateLvX2 : ARRAY[0..15] OF Gate_2 = (

	{0} Row_0, Row_X, Row_2, Row_X, Row_X, Row_X, Row_X, Row_X,
	{8} Row_8, Row_9, Row_A, Row_B, Row_X, Row_X, Row_X, Row_X);

   GateLvl2 :	ARRAY[Row_0..Row_X] OF
		ARRAY[0..15] OF Gating = (

	{[_0,0]} (G_RM6,G_RM7,G_Hit,G_Hit,G_ooo,G_ooo,G_Hit,G_ooo,
	{[_0,8]}  G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo),

	{[_2,0]} (G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_ooo,G_Hit,G_ooo,
	{[_2,8]}  G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo),

	{[_8,0]} (G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,
	{[_8,8]}  G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit),

	{[_9,0]} (G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,
	{[_9,8]}  G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit),

	{[_A,0]} (G_Hit,G_Hit,G_ooo,G_Hit,G_Hit,G_Hit,G_ooo,G_ooo,
	{[_A,8]}  G_Hit,G_Hit,G_ooo,G_Hit,G_Hit,G_Hit,G_ooo,G_Hit),

	{[_B,0]} (G_ooo,G_ooo,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit,
	{[_B,8]}  G_ooo,G_ooo,G_RM8,G_Hit,G_Hit,G_Hit,G_Hit,G_Hit),

	{[_X,0]} (G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,
	{[_X,8]}  G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo,G_ooo));


	{ -------------------------------------------------- }	{.CP16}
	{ 386 Operations Resolved in modR/M 543 Handled Next }
	{ -------------------------------------------------- }

   GateLvl3 :	ARRAY[G_RM1..G_RM9] OF
		ARRAY[0..7] OF Gating = (

	{[_1,0]}  (G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit),
	{[_2,0]}  (G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_ooo, G_Hit),
	{[_3,0]}  (G_Hit, G_ooo, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit),
	{[_4,0]}  (G_Hit, G_Hit, G_ooo, G_ooo, G_ooo, G_ooo, G_ooo, G_ooo),
	{[_5,0]}  (G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_ooo),
	{[_6,0]}  (G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_ooo, G_ooo),
	{[_7,0]}  (G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_ooo, G_Hit, G_ooo),
	{[_8,0]}  (G_ooo, G_ooo, G_ooo, G_ooo, G_Hit, G_Hit, G_Hit, G_Hit),
	{[_9,0]}  (G_Hit, G_ooo, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit, G_Hit));


	{ ------------------------------------------------- }	{.CP08}
	{ Operand Format Driver Vector - 80386 Instructions }
	{ ------------------------------------------------- }

   OpType386 :	ARRAY[0..96] OF TagGrp = (

	{00} ((A: ' '; V: 30), (A: ' '; V: 30), (A: ' '; V: 30)),
	{01} ((A: ' '; V: 30), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{02} ((A: ' '; V: 30), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{03} ((A: 'A'; V: 36), (A: ' '; V: 30), (A: ' '; V: 30)),
	{04} ((A: 'C'; V: 35), (A: 'R'; V: 35), (A: ' '; V: 30)),
	{05} ((A: 'D'; V: 35), (A: 'R'; V: 35), (A: ' '; V: 30)),
	{06} ((A: 'E'; V: 34), (A: ' '; V: 30), (A: ' '; V: 30)),
	{07} ((A: 'E'; V: 34), (A: 'G'; V: 34), (A: ' '; V: 30)),
	{08} ((A: 'E'; V: 34), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{09} ((A: 'E'; V: 34), (A: 'r'; V: 31), (A: ' '; V: 30)),
	{10} ((A: 'E'; V: 34), (A: 'r'; V: 01), (A: ' '; V: 30)),
	{11} ((A: 'E'; V: 36), (A: ' '; V: 30), (A: ' '; V: 30)),
	{12} ((A: 'E'; V: 38), (A: ' '; V: 30), (A: ' '; V: 30)),
	{13} ((A: 'E'; V: 38), (A: 'G'; V: 38), (A: ' '; V: 30)),
	{14} ((A: 'E'; V: 38), (A: 'G'; V: 38), (A: 'I'; V: 34)),
	{15} ((A: 'E'; V: 38), (A: 'G'; V: 38), (A: 'r'; V: 01)),
	{16} ((A: 'E'; V: 38), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{17} ((A: 'E'; V: 38), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{18} ((A: 'E'; V: 38), (A: 'r'; V: 31), (A: ' '; V: 30)),
	{19} ((A: 'E'; V: 38), (A: 'r'; V: 01), (A: ' '; V: 30)),
	{20} ((A: 'E'; V: 39), (A: ' '; V: 30), (A: ' '; V: 30)),
	{21} ((A: 'E'; V: 39), (A: 'G'; V: 39), (A: ' '; V: 30)),
	{22} ((A: 'E'; V: 39), (A: 'S'; V: 39), (A: ' '; V: 30)),
	{23} ((A: 'G'; V: 34), (A: 'E'; V: 34), (A: ' '; V: 30)),
	{24} ((A: 'G'; V: 38), (A: 'E'; V: 34), (A: ' '; V: 30)),
	{25} ((A: 'G'; V: 38), (A: 'E'; V: 38), (A: ' '; V: 30)),
	{26} ((A: 'G'; V: 38), (A: 'E'; V: 38), (A: 'I'; V: 34)),
	{27} ((A: 'G'; V: 38), (A: 'E'; V: 38), (A: 'I'; V: 38)),
	{28} ((A: 'G'; V: 38), (A: 'E'; V: 39), (A: ' '; V: 30)),
	{29} ((A: 'G'; V: 38), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{30} ((A: 'G'; V: 38), (A: 'M'; V: 30), (A: ' '; V: 30)),
	{31} ((A: 'G'; V: 38), (A: 'M'; V: 33), (A: ' '; V: 30)),
	{32} ((A: 'G'; V: 38), (A: 'M'; V: 36), (A: ' '; V: 30)),
	{33} ((A: 'I'; V: 34), (A: ' '; V: 30), (A: ' '; V: 30)),
	{34} ((A: 'I'; V: 34), (A: 'e'; V: 08), (A: ' '; V: 30)),
	{35} ((A: 'I'; V: 34), (A: 'r'; V: 00), (A: ' '; V: 30)),
	{36} ((A: 'I'; V: 38), (A: ' '; V: 30), (A: ' '; V: 30)),
	{37} ((A: 'I'; V: 39), (A: ' '; V: 30), (A: ' '; V: 30)),
	{38} ((A: 'I'; V: 39), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{39} ((A: 'J'; V: 34), (A: ' '; V: 30), (A: ' '; V: 30)),
	{40} ((A: 'J'; V: 38), (A: ' '; V: 30), (A: ' '; V: 30)),
	{41} ((A: 'M'; V: 37), (A: ' '; V: 30), (A: ' '; V: 30)),
	{42} ((A: 'O'; V: 34), (A: 'r'; V: 00), (A: ' '; V: 30)),
	{43} ((A: 'O'; V: 38), (A: 'e'; V: 08), (A: ' '; V: 30)),
	{44} ((A: 'R'; V: 35), (A: 'C'; V: 35), (A: ' '; V: 30)),
	{45} ((A: 'R'; V: 35), (A: 'D'; V: 35), (A: ' '; V: 30)),
	{46} ((A: 'R'; V: 35), (A: 'T'; V: 35), (A: ' '; V: 30)),
	{47} ((A: 'S'; V: 39), (A: 'E'; V: 39), (A: ' '; V: 30)),
	{48} ((A: 'T'; V: 35), (A: 'R'; V: 35), (A: ' '; V: 30)),
	{49} ((A: 'e'; V: 08), (A: ' '; V: 30), (A: ' '; V: 30)),
	{50} ((A: 'e'; V: 08), (A: 'E'; V: 38), (A: ' '; V: 30)),
	{51} ((A: 'e'; V: 08), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{52} ((A: 'e'; V: 08), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{53} ((A: 'e'; V: 08), (A: 'O'; V: 38), (A: ' '; V: 30)),
	{54} ((A: 'e'; V: 08), (A: 'e'; V: 13), (A: ' '; V: 30)),
	{55} ((A: 'e'; V: 08), (A: 'e'; V: 11), (A: ' '; V: 30)),
	{56} ((A: 'e'; V: 08), (A: 'e'; V: 09), (A: ' '; V: 30)),
	{57} ((A: 'e'; V: 08), (A: 'e'; V: 15), (A: ' '; V: 30)),
	{58} ((A: 'e'; V: 08), (A: 'e'; V: 10), (A: ' '; V: 30)),
	{59} ((A: 'e'; V: 08), (A: 'e'; V: 14), (A: ' '; V: 30)),
	{60} ((A: 'e'; V: 08), (A: 'e'; V: 12), (A: ' '; V: 30)),
	{61} ((A: 'e'; V: 08), (A: 'r'; V: 10), (A: ' '; V: 30)),
	{62} ((A: 'e'; V: 13), (A: ' '; V: 30), (A: ' '; V: 30)),
	{63} ((A: 'e'; V: 13), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{64} ((A: 'e'; V: 11), (A: ' '; V: 30), (A: ' '; V: 30)),
	{65} ((A: 'e'; V: 11), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{66} ((A: 'e'; V: 09), (A: ' '; V: 30), (A: ' '; V: 30)),
	{67} ((A: 'e'; V: 09), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{68} ((A: 'e'; V: 15), (A: ' '; V: 30), (A: ' '; V: 30)),
	{69} ((A: 'e'; V: 15), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{70} ((A: 'e'; V: 10), (A: ' '; V: 30), (A: ' '; V: 30)),
	{71} ((A: 'e'; V: 10), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{72} ((A: 'e'; V: 14), (A: ' '; V: 30), (A: ' '; V: 30)),
	{73} ((A: 'e'; V: 14), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{74} ((A: 'e'; V: 12), (A: ' '; V: 30), (A: ' '; V: 30)),
	{75} ((A: 'e'; V: 12), (A: 'I'; V: 38), (A: ' '; V: 30)),
	{76} ((A: 'r'; V: 32), (A: ' '; V: 30), (A: ' '; V: 30)),
	{77} ((A: 'r'; V: 04), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{78} ((A: 'r'; V: 00), (A: 'E'; V: 34), (A: ' '; V: 30)),
	{79} ((A: 'r'; V: 00), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{80} ((A: 'r'; V: 00), (A: 'O'; V: 34), (A: ' '; V: 30)),
	{81} ((A: 'r'; V: 00), (A: 'r'; V: 10), (A: ' '; V: 30)),
	{82} ((A: 'r'; V: 07), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{83} ((A: 'r'; V: 03), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{84} ((A: 'r'; V: 05), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{85} ((A: 'r'; V: 01), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{86} ((A: 'r'; V: 25), (A: ' '; V: 30), (A: ' '; V: 30)),
	{87} ((A: 'r'; V: 06), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{88} ((A: 'r'; V: 02), (A: 'I'; V: 34), (A: ' '; V: 30)),
	{89} ((A: 'r'; V: 27), (A: ' '; V: 30), (A: ' '; V: 30)),
	{90} ((A: 'r'; V: 10), (A: 'e'; V: 08), (A: ' '; V: 30)),
	{91} ((A: 'r'; V: 10), (A: 'r'; V: 00), (A: ' '; V: 30)),
	{92} ((A: 'r'; V: 24), (A: ' '; V: 30), (A: ' '; V: 30)),
	{93} ((A: 'r'; V: 28), (A: ' '; V: 30), (A: ' '; V: 30)),
	{94} ((A: 'r'; V: 29), (A: ' '; V: 30), (A: ' '; V: 30)),
	{95} ((A: 'r'; V: 26), (A: ' '; V: 30), (A: ' '; V: 30)),
	{96} ((A: 'E'; V: 33), (A: ' '; V: 30), (A: ' '; V: 30)));


   ActLvl1 : ARRAY[$00..$FF] OF CpuVec = (			{.CP04}

	({00} F:$08+O0; M:006; T:07),	({01} F:$68+O0; M:006; T:13),
	({02} F:$08+O0; M:006; T:23),	({03} F:$68+O0; M:006; T:25),
	({04} F:$00+O0; M:006; T:79),	({05} F:$60+O0; M:006; T:52),
	({06} F:$20+O0; M:106; T:92),	({07} F:$00+O0; M:101; T:92),
	({08} F:$08+O0; M:096; T:07),	({09} F:$68+O0; M:096; T:13),
	({0A} F:$08+O0; M:096; T:23),	({0B} F:$68+O0; M:096; T:25),
	({0C} F:$00+O0; M:096; T:79),	({0D} F:$60+O0; M:096; T:52),
	({0E} F:$20+O0; M:106; T:86),	({0F} F:$00+O0; M:000; T:00),
	({10} F:$08+O0; M:005; T:07),	({11} F:$68+O0; M:005; T:13),
	({12} F:$08+O0; M:005; T:23),	({13} F:$68+O0; M:005; T:25),
	({14} F:$00+O0; M:005; T:79),	({15} F:$60+O0; M:005; T:52),
	({16} F:$20+O0; M:106; T:95),	({17} F:$00+O0; M:101; T:95),
	({18} F:$08+O0; M:121; T:07),	({19} F:$68+O0; M:121; T:13),
	({1A} F:$08+O0; M:121; T:23),	({1B} F:$68+O0; M:121; T:25),
	({1C} F:$00+O0; M:121; T:79),	({1D} F:$60+O0; M:121; T:52),
	({1E} F:$20+O0; M:106; T:89),	({1F} F:$00+O0; M:101; T:89),
	({20} F:$08+O0; M:007; T:07),	({21} F:$68+O0; M:007; T:13),
	({22} F:$08+O0; M:007; T:23),	({23} F:$68+O0; M:007; T:25),
	({24} F:$00+O0; M:007; T:79),	({25} F:$60+O0; M:007; T:52),
	({26} F:$00+O0; M:127; T:00),	({27} F:$00+O0; M:030; T:00),
	({28} F:$08+O0; M:162; T:07),	({29} F:$68+O0; M:162; T:13),
	({2A} F:$08+O0; M:162; T:23),	({2B} F:$68+O0; M:162; T:25),
	({2C} F:$00+O0; M:162; T:79),	({2D} F:$60+O0; M:162; T:52),
	({2E} F:$00+O0; M:125; T:00),	({2F} F:$00+O0; M:031; T:00),
	({30} F:$08+O0; M:169; T:07),	({31} F:$68+O0; M:169; T:13),
	({32} F:$08+O0; M:169; T:23),	({33} F:$48+O0; M:169; T:25),
	({34} F:$00+O0; M:169; T:79),	({35} F:$60+O0; M:169; T:52),
	({36} F:$00+O0; M:130; T:00),	({37} F:$00+O0; M:001; T:00),
	({38} F:$08+O0; M:024; T:07),	({39} F:$68+O0; M:024; T:13),
	({3A} F:$08+O0; M:024; T:23),	({3B} F:$68+O0; M:024; T:25),
	({3C} F:$00+O0; M:024; T:79),	({3D} F:$60+O0; M:024; T:52),
	({3E} F:$00+O0; M:126; T:00),	({3F} F:$00+O0; M:004; T:00),
	({40} F:$60+O0; M:039; T:49),	({41} F:$60+O0; M:039; T:66),
	({42} F:$60+O0; M:039; T:70),	({43} F:$60+O0; M:039; T:64),
	({44} F:$60+O0; M:039; T:74),	({45} F:$60+O0; M:039; T:62),
	({46} F:$60+O0; M:039; T:72),	({47} F:$60+O0; M:039; T:68),
	({48} F:$60+O0; M:032; T:49),	({49} F:$60+O0; M:032; T:66),
	({4A} F:$60+O0; M:032; T:70),	({4B} F:$60+O0; M:032; T:64),
	({4C} F:$60+O0; M:032; T:74),	({4D} F:$60+O0; M:032; T:62),
	({4E} F:$60+O0; M:032; T:72),	({4F} F:$60+O0; M:032; T:68),
	({50} F:$60+O0; M:106; T:49),	({51} F:$60+O0; M:106; T:66),
	({52} F:$60+O0; M:106; T:70),	({53} F:$60+O0; M:106; T:64),
	({54} F:$60+O0; M:106; T:74),	({55} F:$60+O0; M:106; T:62),
	({56} F:$60+O0; M:106; T:72),	({57} F:$60+O0; M:106; T:68),
	({58} F:$60+O0; M:101; T:49),	({59} F:$60+O0; M:101; T:66),
	({5A} F:$60+O0; M:101; T:70),	({5B} F:$60+O0; M:101; T:64),
	({5C} F:$60+O0; M:101; T:74),	({5D} F:$60+O0; M:101; T:62),
	({5E} F:$60+O0; M:101; T:72),	({5F} F:$60+O0; M:101; T:68),
	({60} F:$E0+O1; M:107; T:00),	({61} F:$E0+O1; M:102; T:00),
	({62} F:$68+O1; M:009; T:31),	({63} F:$08+O2; M:008; T:21),
	({64} F:$00+O3; M:128; T:00),	({65} F:$00+O3; M:129; T:00),
	({66} F:$00+O3; M:000; T:00),	({67} F:$00+O3; M:000; T:00),
	({68} F:$60+O1; M:106; T:36),	({69} F:$68+O1; M:037; T:27),
	({6A} F:$00+O1; M:106; T:33),	({6B} F:$78+O1; M:037; T:26),
	({6C} F:$00+O1; M:040; T:00),	({6D} F:$C0+O1; M:041; T:00),
	({6E} F:$00+O1; M:098; T:00),	({6F} F:$E0+O1; M:099; T:00),
	({70} F:$00+O0; M:060; T:39),	({71} F:$00+O0; M:056; T:39),
	({72} F:$00+O0; M:046; T:39),	({73} F:$00+O0; M:052; T:39),
	({74} F:$00+O0; M:063; T:39),	({75} F:$00+O0; M:059; T:39),
	({76} F:$00+O0; M:047; T:39),	({77} F:$00+O0; M:053; T:39),
	({78} F:$00+O0; M:062; T:39),	({79} F:$00+O0; M:058; T:39),
	({7A} F:$00+O0; M:061; T:39),	({7B} F:$00+O0; M:057; T:39),
	({7C} F:$00+O0; M:170; T:39),	({7D} F:$00+O0; M:054; T:39),
	({7E} F:$00+O0; M:050; T:39),	({7F} F:$00+O0; M:055; T:39),
	({80} F:$00+O0; M:000; T:08),	({81} F:$60+O0; M:000; T:17),
	({82} F:$00+O0; M:000; T:00),	({83} F:$70+O0; M:000; T:16),
	({84} F:$08+O0; M:163; T:07),	({85} F:$68+O0; M:163; T:13),
	({86} F:$08+O0; M:167; T:07),	({87} F:$68+O0; M:167; T:13),
	({88} F:$08+O0; M:086; T:07),	({89} F:$68+O0; M:086; T:13),
	({8A} F:$08+O0; M:086; T:23),	({8B} F:$68+O0; M:086; T:25),
	({8C} F:$28+O0; M:086; T:22),	({8D} F:$68+O0; M:067; T:30),
	({8E} F:$28+O0; M:086; T:47),	({8F} F:$68+O0; M:101; T:12),
	({90} F:$00+O0; M:094; T:00),	({91} F:$60+O0; M:167; T:56),
	({92} F:$40+O0; M:167; T:58),	({93} F:$60+O0; M:167; T:55),
	({94} F:$60+O0; M:167; T:60),	({95} F:$60+O0; M:167; T:54),
	({96} F:$60+O0; M:167; T:59),	({97} F:$60+O0; M:167; T:57),
	({98} F:$F0+O0; M:017; T:00),	({99} F:$E0+O0; M:028; T:00),
	({9A} F:$00+O0; M:016; T:03),	({9B} F:$00+O0; M:166; T:00),
	({9C} F:$E0+O0; M:109; T:00),	({9D} F:$E0+O0; M:104; T:00),
	({9E} F:$00+O0; M:119; T:00),	({9F} F:$00+O0; M:064; T:00),
	({A0} F:$00+O0; M:086; T:80),	({A1} F:$60+O0; M:086; T:53),
	({A2} F:$00+O0; M:086; T:42),	({A3} F:$60+O0; M:086; T:43),
	({A4} F:$00+O0; M:087; T:00),	({A5} F:$E0+O0; M:088; T:00),
	({A6} F:$00+O0; M:025; T:00),	({A7} F:$E0+O0; M:026; T:00),
	({A8} F:$00+O0; M:163; T:79),	({A9} F:$60+O0; M:163; T:52),
	({AA} F:$00+O0; M:158; T:00),	({AB} F:$E0+O0; M:159; T:00),
	({AC} F:$00+O0; M:077; T:00),	({AD} F:$C0+O0; M:078; T:00),
	({AE} F:$00+O0; M:122; T:00),	({AF} F:$E0+O0; M:123; T:00),
	({B0} F:$00+O0; M:086; T:79),	({B1} F:$00+O0; M:086; T:85),
	({B2} F:$00+O0; M:086; T:88),	({B3} F:$00+O0; M:086; T:83),
	({B4} F:$00+O0; M:086; T:77),	({B5} F:$00+O0; M:086; T:84),
	({B6} F:$00+O0; M:086; T:87),	({B7} F:$00+O0; M:086; T:82),
	({B8} F:$60+O0; M:086; T:52),	({B9} F:$60+O0; M:086; T:67),
	({BA} F:$60+O0; M:086; T:71),	({BB} F:$60+O0; M:086; T:65),
	({BC} F:$60+O0; M:086; T:75),	({BD} F:$60+O0; M:086; T:63),
	({BE} F:$60+O0; M:086; T:73),	({BF} F:$60+O0; M:086; T:69),
	({C0} F:$00+O1; M:000; T:08),	({C1} F:$60+O1; M:000; T:16),
	({C2} F:$00+O0; M:115; T:37),	({C3} F:$00+O0; M:115; T:00),
	({C4} F:$68+O0; M:069; T:32),	({C5} F:$68+O0; M:066; T:32),
	({C6} F:$08+O0; M:086; T:08),	({C7} F:$68+O0; M:086; T:17),
	({C8} F:$00+O1; M:034; T:38),	({C9} F:$00+O1; M:068; T:00),
	({CA} F:$00+O0; M:116; T:37),	({CB} F:$00+O0; M:116; T:00),
	({CC} F:$00+O0; M:043; T:76),	({CD} F:$00+O0; M:043; T:33),
	({CE} F:$00+O0; M:044; T:00),	({CF} F:$00+O0; M:045; T:00),
	({D0} F:$00+O0; M:000; T:09),	({D1} F:$60+O0; M:000; T:18),
	({D2} F:$00+O0; M:000; T:10),	({D3} F:$60+O0; M:000; T:19),
	({D4} F:$00+O0; M:003; T:00),	({D5} F:$00+O0; M:002; T:00),
	({D6} F:$00+O0; M:000; T:00),	({D7} F:$00+O0; M:168; T:00),
	({D8} F:$00+O0; M:000; T:00),	({D9} F:$00+O0; M:000; T:00),
	({DA} F:$00+O0; M:000; T:00),	({DB} F:$00+O0; M:000; T:00),
	({DC} F:$00+O0; M:000; T:00),	({DD} F:$00+O0; M:000; T:00),
	({DE} F:$00+O0; M:000; T:00),	({DF} F:$00+O0; M:000; T:00),
	({E0} F:$00+O0; M:082; T:39),	({E1} F:$00+O0; M:081; T:39),
	({E2} F:$00+O0; M:080; T:39),	({E3} F:$E0+O0; M:048; T:39),
	({E4} F:$00+O0; M:038; T:79),	({E5} F:$60+O0; M:038; T:51),
	({E6} F:$00+O0; M:097; T:35),	({E7} F:$60+O0; M:097; T:34),
	({E8} F:$60+O0; M:016; T:40),	({E9} F:$40+O0; M:051; T:40),
	({EA} F:$40+O0; M:051; T:03),	({EB} F:$00+O0; M:051; T:39),
	({EC} F:$00+O0; M:038; T:81),	({ED} F:$60+O0; M:038; T:61),
	({EE} F:$00+O0; M:097; T:91),	({EF} F:$60+O0; M:097; T:90),
	({F0} F:$00+O0; M:076; T:00),	({F1} F:$00+O0; M:000; T:00),
	({F2} F:$00+O0; M:114; T:00),	({F3} F:$00+O0; M:113; T:00),
	({F4} F:$00+O0; M:035; T:00),	({F5} F:$00+O0; M:023; T:00),
	({F6} F:$00+O0; M:000; T:06),	({F7} F:$00+O0; M:000; T:12),
	({F8} F:$00+O0; M:019; T:00),	({F9} F:$00+O0; M:155; T:00),
	({FA} F:$00+O0; M:021; T:00),	({FB} F:$00+O0; M:157; T:00),
	({FC} F:$00+O0; M:020; T:00),	({FD} F:$00+O0; M:156; T:00),
	({FE} F:$00+O0; M:000; T:00),	({FF} F:$00+O0; M:000; T:00));


   ActLvl2 :	ARRAY[Row_0..Row_B]	OF	      {2-byte Row Index}{.CP05}
		ARRAY[$00..$0F] 	OF CpuVec = ( {2-byte Col Index}

	{_0,0} ((F:$00+O0; M:000; T:00),	{_0,1} (F:$00+O0; M:000; T:00),
	{_0,2}  (F:$48+O2; M:065; T:28),	{_0,3} (F:$68+O2; M:083; T:28),
	{_0,4}  (F:$00+O0; M:000; T:00),	{_0,5} (F:$00+O0; M:000; T:00),
	{_0,6}  (F:$00+O2; M:022; T:00),	{_0,7} (F:$00+O0; M:000; T:00),
	{_0,8}  (F:$00+O0; M:000; T:00),	{_0,9} (F:$00+O0; M:000; T:00),
	{_0,A}  (F:$00+O0; M:000; T:00),	{_0,B} (F:$00+O0; M:000; T:00),
	{_0,C}  (F:$00+O0; M:000; T:00),	{_0,D} (F:$00+O0; M:000; T:00),
	{_0,E}  (F:$00+O0; M:000; T:00),	{_0,F} (F:$00+O0; M:000; T:00)),
	{_2,0} ((F:$08+O3; M:086; T:04),	{_2,1} (F:$08+O3; M:086; T:05),
	{_2,2}  (F:$08+O3; M:086; T:44),	{_2,3} (F:$08+O3; M:086; T:45),
	{_2,4}  (F:$08+O3; M:086; T:48),	{_2,5} (F:$00+O0; M:000; T:00),
	{_2,6}  (F:$08+O3; M:086; T:46),	{_2,7} (F:$00+O0; M:000; T:00),
	{_2,8}  (F:$00+O0; M:000; T:00),	{_2,9} (F:$00+O0; M:000; T:00),
	{_2,A}  (F:$00+O0; M:000; T:00),	{_2,B} (F:$00+O0; M:000; T:00),
	{_2,C}  (F:$00+O0; M:000; T:00),	{_2,D} (F:$00+O0; M:000; T:00),
	{_2,E}  (F:$00+O0; M:000; T:00),	{_2,F} (F:$00+O0; M:000; T:00)),
	{_8,0} ((F:$40+O3; M:060; T:40),	{_8,1} (F:$40+O3; M:056; T:40),
	{_8,2}  (F:$40+O3; M:046; T:40),	{_8,3} (F:$40+O3; M:052; T:40),
	{_8,4}  (F:$40+O3; M:063; T:40),	{_8,5} (F:$40+O3; M:059; T:40),
	{_8,6}  (F:$40+O3; M:047; T:40),	{_8,7} (F:$40+O3; M:053; T:40),
	{_8,8}  (F:$40+O3; M:062; T:40),	{_8,9} (F:$40+O3; M:058; T:40),
	{_8,A}  (F:$40+O3; M:061; T:40),	{_8,B} (F:$40+O3; M:057; T:40),
	{_8,C}  (F:$40+O3; M:170; T:40),	{_8,D} (F:$40+O3; M:054; T:40),
	{_8,E}  (F:$40+O3; M:050; T:40),	{_8,F} (F:$40+O3; M:055; T:40)),
	{_9,0} ((F:$08+O3; M:143; T:06),	{_9,1} (F:$08+O3; M:139; T:06),
	{_9,2}  (F:$08+O3; M:131; T:06),	{_9,3} (F:$08+O3; M:135; T:06),
	{_9,4}  (F:$08+O3; M:146; T:06),	{_9,5} (F:$08+O3; M:142; T:06),
	{_9,6}  (F:$08+O3; M:132; T:06),	{_9,7} (F:$08+O3; M:136; T:06),
	{_9,8}  (F:$08+O3; M:145; T:06),	{_9,9} (F:$08+O3; M:141; T:06),
	{_9,A}  (F:$08+O3; M:144; T:06),	{_9,B} (F:$08+O3; M:140; T:06),
	{_9,C}  (F:$08+O3; M:133; T:06),	{_9,D} (F:$08+O3; M:137; T:06),
	{_9,E}  (F:$08+O3; M:134; T:06),	{_9,F} (F:$08+O3; M:138; T:06)),
	{_A,0} ((F:$20+O3; M:106; T:93),	{_A,1} (F:$00+O3; M:101; T:93),
	{_A,2}  (F:$00+O0; M:000; T:00),	{_A,3} (F:$68+O3; M:012; T:13),
	{_A,4}  (F:$68+O3; M:149; T:14),	{_A,5} (F:$68+O3; M:149; T:15),
	{_A,6}  (F:$00+O0; M:000; T:00),	{_A,7} (F:$00+O0; M:000; T:00),
	{_A,8}  (F:$20+O3; M:106; T:94),	{_A,9} (F:$00+O3; M:101; T:94),
	{_A,A}  (F:$00+O0; M:000; T:00),	{_A,B} (F:$68+O3; M:015; T:13),
	{_A,C}  (F:$68+O3; M:151; T:14),	{_A,D} (F:$68+O3; M:151; T:15),
	{_A,E}  (F:$00+O0; M:000; T:00),	{_A,F} (F:$68+O3; M:037; T:25)),
	{_B,0} ((F:$00+O0; M:000; T:00),	{_B,1} (F:$00+O0; M:000; T:00),
	{_B,2}  (F:$68+O3; M:084; T:32),	{_B,3} (F:$68+O3; M:014; T:13),
	{_B,4}  (F:$68+O3; M:070; T:32),	{_B,5} (F:$68+O3; M:072; T:32),
	{_B,6}  (F:$78+O3; M:091; T:24),	{_B,7} (F:$78+O3; M:091; T:28),
	{_B,8}  (F:$00+O0; M:000; T:00),	{_B,9} (F:$00+O0; M:000; T:00),
	{_B,A}  (F:$00+O0; M:000; T:00),	{_B,B} (F:$68+O3; M:013; T:13),
	{_B,C}  (F:$68+O3; M:010; T:25),	{_B,D} (F:$68+O3; M:011; T:25),
	{_B,E}  (F:$78+O3; M:090; T:24),	{_B,F} (F:$78+O3; M:090; T:28)));


   ActLvl3 :	ARRAY[G_RM1..G_RM9]	OF	      {modR/M Group Index}{.CP05}
		ARRAY[$00..$07] 	OF CpuVec = ( {modR/M Reg   Index}

	{G_RM1,0} ((F:$00+O0; M:006; T:00),	{G_RM1,1}  (F:$00+O0; M:096; T:00),
	{G_RM1,2}  (F:$00+O0; M:005; T:00),	{G_RM1,3}  (F:$00+O0; M:121; T:00),
	{G_RM1,4}  (F:$00+O0; M:007; T:00),	{G_RM1,5}  (F:$00+O0; M:162; T:00),
	{G_RM1,6}  (F:$00+O0; M:169; T:00),	{G_RM1,7}  (F:$00+O0; M:024; T:00)),

	{G_RM2,0} ((F:$00+O0; M:117; T:00),	{G_RM2,1}  (F:$00+O0; M:118; T:00),
	{G_RM2,2}  (F:$00+O0; M:111; T:00),	{G_RM2,3}  (F:$00+O0; M:112; T:00),
	{G_RM2,4}  (F:$00+O0; M:148; T:00),	{G_RM2,5}  (F:$00+O0; M:150; T:00),
	{G_RM2,6}  (F:$00+O0; M:000; T:00),	{G_RM2,7}  (F:$00+O0; M:120; T:00)),

	{G_RM3,0} ((F:$00+O0; M:163; T:01),	{G_RM3,1}  (F:$00+O0; M:000; T:00),
	{G_RM3,2}  (F:$00+O0; M:095; T:00),	{G_RM3,3}  (F:$00+O0; M:093; T:00),
	{G_RM3,4}  (F:$00+O0; M:092; T:78),	{G_RM3,5}  (F:$00+O0; M:037; T:00),
	{G_RM3,6}  (F:$00+O0; M:033; T:00),	{G_RM3,7}  (F:$00+O0; M:036; T:00)),

	{G_RM4,0} ((F:$00+O0; M:039; T:06),	{G_RM4,1}  (F:$00+O0; M:032; T:06),
	{G_RM4,2}  (F:$00+O0; M:000; T:00),	{G_RM4,3}  (F:$00+O0; M:000; T:00),
	{G_RM4,4}  (F:$00+O0; M:000; T:00),	{G_RM4,5}  (F:$00+O0; M:000; T:00),
	{G_RM4,6}  (F:$00+O0; M:000; T:00),	{G_RM4,7}  (F:$00+O0; M:000; T:00)),

	{G_RM5,0} ((F:$60+O0; M:039; T:12),	{G_RM5,1}  (F:$60+O0; M:032; T:12),
	{G_RM5,2}  (F:$60+O0; M:016; T:12),	{G_RM5,3}  (F:$20+O0; M:016; T:11),
	{G_RM5,4}  (F:$40+O0; M:051; T:12),	{G_RM5,5}  (F:$40+O0; M:051; T:11),
	{G_RM5,6}  (F:$60+O0; M:106; T:12),	{G_RM5,7}  (F:$00+O0; M:000; T:00)),

	{G_RM6,0} ((F:$00+O2; M:153; T:20),	{G_RM6,1}  (F:$00+O2; M:161; T:20),
	{G_RM6,2}  (F:$20+O2; M:074; T:20),	{G_RM6,3}  (F:$00+O2; M:085; T:20),
	{G_RM6,4}  (F:$00+O2; M:164; T:20),	{G_RM6,5}  (F:$00+O2; M:165; T:20),
	{G_RM6,6}  (F:$00+O0; M:000; T:00),	{G_RM6,7}  (F:$00+O0; M:000; T:00)),

	{G_RM7,0} ((F:$00+O2; M:147; T:41),	{G_RM7,1}  (F:$00+O2; M:152; T:41),
	{G_RM7,2}  (F:$40+O2; M:071; T:41),	{G_RM7,3}  (F:$40+O2; M:073; T:41),
	{G_RM7,4}  (F:$00+O2; M:154; T:20),	{G_RM7,5}  (F:$00+O0; M:000; T:00),
	{G_RM7,6}  (F:$00+O2; M:075; T:20),	{G_RM7,7}  (F:$00+O0; M:000; T:00)),

	{G_RM8,0} ((F:$00+O0; M:000; T:00),	{G_RM8,1}  (F:$00+O0; M:000; T:00),
	{G_RM8,2}  (F:$00+O0; M:000; T:00),	{G_RM8,3}  (F:$00+O0; M:000; T:00),
	{G_RM8,4}  (F:$60+O3; M:012; T:16),	{G_RM8,5}  (F:$60+O3; M:015; T:16),
	{G_RM8,6}  (F:$60+O3; M:014; T:16),	{G_RM8,7}  (F:$60+O3; M:013; T:16)),

	{G_RM9,0} ((F:$60+O0; M:163; T:02),	{G_RM9,1}  (F:$00+O0; M:000; T:00),
	{G_RM9,2}  (F:$60+O0; M:095; T:00),	{G_RM9,3}  (F:$60+O0; M:093; T:00),
	{G_RM9,4}  (F:$60+O0; M:092; T:50),	{G_RM9,5}  (F:$60+O0; M:037; T:00),
	{G_RM9,6}  (F:$60+O0; M:033; T:00),	{G_RM9,7}  (F:$60+O0; M:036; T:00)));



   MrmTab :	ARRAY[TAdr] OF	{ addressing }		{.CP08}
		ARRAY[0..2] OF	{ mod values }
		ARRAY[0..7] OF	{ R/M values }

			TMrm = (

	{[Adr16,0,0]}(((D:0; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:14 {SI}),
	{[Adr16,0,1]}  (D:0; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:15 {DI}),
	{[Adr16,0,2]}  (D:0; SIB:0; rS:26 {SS}; rB:13 {BP};  rX:14 {SI}),
	{[Adr16,0,3]}  (D:0; SIB:0; rS:26 {SS}; rB:13 {BP};  rX:15 {DI}),
	{[Adr16,0,4]}  (D:0; SIB:0; rS:27 {DS}; rB:14 {SI};  rX:30 {}),
	{[Adr16,0,5]}  (D:0; SIB:0; rS:27 {DS}; rB:15 {DI};  rX:30 {}),
	{[Adr16,0,6]}  (D:2; SIB:0; rS:27 {DS}; rB:30 {};    rX:30 {}),
	{[Adr16,0,7]}  (D:0; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:30 {})),

	{[Adr16,1,0]} ((D:1; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:14 {SI}),
	{[Adr16,1,1]}  (D:1; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:15 {DI}),
	{[Adr16,1,2]}  (D:1; SIB:0; rS:26 {SS}; rB:13 {BP};  rX:14 {SI}),
	{[Adr16,1,3]}  (D:1; SIB:0; rS:26 {SS}; rB:13 {BP};  rX:15 {DI}),
	{[Adr16,1,4]}  (D:1; SIB:0; rS:27 {DS}; rB:14 {SI};  rX:30 {}),
	{[Adr16,1,5]}  (D:1; SIB:0; rS:27 {DS}; rB:15 {DI};  rX:30 {}),
	{[Adr16,1,6]}  (D:1; SIB:0; rS:26 {SS}; rB:13 {BP};  rX:30 {}),
	{[Adr16,1,7]}  (D:1; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:30 {})),

	{[Adr16,2,0]} ((D:2; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:14 {SI}),
	{[Adr16,2,1]}  (D:2; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:15 {DI}),
	{[Adr16,2,2]}  (D:2; SIB:0; rS:26 {SS}; rB:13 {BP};  rX:14 {SI}),
	{[Adr16,2,3]}  (D:2; SIB:0; rS:26 {SS}; rB:13 {BP};  rX:15 {DI}),
	{[Adr16,2,4]}  (D:2; SIB:0; rS:27 {DS}; rB:14 {SI};  rX:30 {}),
	{[Adr16,2,5]}  (D:2; SIB:0; rS:27 {DS}; rB:15 {DI};  rX:30 {}),
	{[Adr16,2,6]}  (D:2; SIB:0; rS:26 {SS}; rB:13 {BP};  rX:30 {}),
	{[Adr16,2,7]}  (D:2; SIB:0; rS:27 {DS}; rB:11 {BX};  rX:30 {}))),

	{[Adr32,0,0]}(((D:0; SIB:0; rS:27 {DS}; rB:16 {EAX}; rX:30 {}),
	{[Adr32,0,1]}  (D:0; SIB:0; rS:27 {DS}; rB:17 {ECX}; rX:30 {}),
	{[Adr32,0,2]}  (D:0; SIB:0; rS:27 {DS}; rB:18 {EDX}; rX:30 {}),
	{[Adr32,0,3]}  (D:0; SIB:0; rS:27 {DS}; rB:19 {EBX}; rX:30 {}),
	{[Adr32,0,4]}  (D:0; SIB:1; rS:30 {};   rB:30 {};    rX:30 {}),
	{[Adr32,0,5]}  (D:4; SIB:0; rS:27 {DS}; rB:30 {};    rX:30 {}),
	{[Adr32,0,6]}  (D:0; SIB:0; rS:27 {DS}; rB:22 {ESI}; rX:30 {}),
	{[Adr32,0,7]}  (D:0; SIB:0; rS:27 {DS}; rB:23 {EDI}; rX:30 {})),

	{[Adr32,1,0]} ((D:1; SIB:0; rS:27 {DS}; rB:16 {EAX}; rX:30 {}),
	{[Adr32,1,1]}  (D:1; SIB:0; rS:27 {DS}; rB:17 {ECX}; rX:30 {}),
	{[Adr32,1,2]}  (D:1; SIB:0; rS:27 {DS}; rB:18 {EDX}; rX:30 {}),
	{[Adr32,1,3]}  (D:1; SIB:0; rS:27 {DS}; rB:19 {EBX}; rX:30 {}),
	{[Adr32,1,4]}  (D:0; SIB:1; rS:30 {};   rB:30 {};    rX:30 {}),
	{[Adr32,1,5]}  (D:1; SIB:0; rS:26 {SS}; rB:21 {EBP}; rX:30 {}),
	{[Adr32,1,6]}  (D:1; SIB:0; rS:27 {DS}; rB:22 {ESI}; rX:30 {}),
	{[Adr32,1,7]}  (D:1; SIB:0; rS:27 {DS}; rB:23 {EDI}; rX:30 {})),

	{[Adr32,2,0]} ((D:4; SIB:0; rS:27 {DS}; rB:16 {EAX}; rX:30 {}),
	{[Adr32,2,1]}  (D:4; SIB:0; rS:27 {DS}; rB:17 {ECX}; rX:30 {}),
	{[Adr32,2,2]}  (D:4; SIB:0; rS:27 {DS}; rB:18 {EDX}; rX:30 {}),
	{[Adr32,2,3]}  (D:4; SIB:0; rS:27 {DS}; rB:19 {EBX}; rX:30 {}),
	{[Adr32,2,4]}  (D:0; SIB:1; rS:30 {};   rB:30 {};    rX:30 {}),
	{[Adr32,2,5]}  (D:4; SIB:0; rS:26 {SS}; rB:21 {EBP}; rX:30 {}),
	{[Adr32,2,6]}  (D:4; SIB:0; rS:27 {DS}; rB:22 {ESI}; rX:30 {}),
	{[Adr32,2,7]}  (D:4; SIB:0; rS:27 {DS}; rB:23 {EDI}; rX:30 {}))));

   RegList : ARRAY[00..41] OF STRING[3] = (			{.CP12}

	{00}  'AL', 	{01}  'CL', 	{02}  'DL', 	{03}  'BL',
	{04}  'AH', 	{05}  'CH', 	{06}  'DH', 	{07}  'BH', 
	{08}  'AX', 	{09}  'CX', 	{10}  'DX', 	{11}  'BX',
	{12}  'SP', 	{13}  'BP', 	{14}  'SI', 	{15}  'DI',
	{16}  'EAX',	{17}  'ECX',	{18}  'EDX',	{19}  'EBX',
	{20}  'ESP',	{21}  'EBP',	{22}  'ESI',	{23}  'EDI',
	{24}  'ES', 	{25}  'CS', 	{26}  'SS', 	{27}  'DS',
	{28}  'FS', 	{29}  'GS', 	{30}  '',	{31}  '1',
	{32}  '3',	{33}  'a',	{34}  'b',	{35}  'd',
	{36}  'p',	{37}  's',	{38}  'v',	{39}  'w',
	{40}  'q',	{41}  't');


   RegDecode :  ARRAY[TAdr] OF					{.CP12}
		ARRAY[WBitStatus] OF
		ARRAY[0..7] OF BYTE = (  {decodes GP Reg fields}

   {[Adr16,W0,0]}	((00 {AL},  01 {CL},  02 {DL},  03 {BL},
			  04 {AH},  05 {CH},  06 {DH},  07 {BH}),
   {[Adr16,W1,0]}	 (08 {AX},  09 {CX},  10 {DX},  11 {BX},
			  12 {SP},  13 {BP},  14 {SI},  15 {DI})),
   {[Adr32,W0,0]}	((00 {AL},  01 {CL},  02 {DL},  03 {BL},
			  04 {AH},  05 {CH},  06 {DH},  07 {BH}),
   {[Adr32,W1,0]}	 (16 {EAX}, 17 {ECX}, 18 {EDX}, 19 {EBX},
			  20 {ESP}, 21 {EBP}, 22 {ESI}, 23 {EDI})));


     SibTab :	ARRAY[0..2] OF  { mrmMOD indexes this }		{.CP28}
		ARRAY[0..7] OF  { sibBAS indexes this }
		SibRec = (

	{[0,0]}  ((D: 0; rS: 27 {DS}; rB: 16 {EAX}),
	{[0,1]}   (D: 0; rS: 27 {DS}; rB: 17 {ECX}),
	{[0,2]}   (D: 0; rS: 27 {DS}; rB: 18 {EDX}),
	{[0,3]}   (D: 0; rS: 27 {DS}; rB: 19 {EBX}),
	{[0,4]}   (D: 0; rS: 26 {SS}; rB: 20 {ESP}),
	{[0,5]}   (D: 4; rS: 27 {DS}; rB: 30 {}),
	{[0,6]}   (D: 0; rS: 27 {DS}; rB: 22 {ESI}),
	{[0,7]}   (D: 0; rS: 27 {DS}; rB: 23 {EDI})),
	{[1,0]}  ((D: 1; rS: 27 {DS}; rB: 16 {EAX}),
	{[1,1]}   (D: 1; rS: 27 {DS}; rB: 17 {ECX}),
	{[1,2]}   (D: 1; rS: 27 {DS}; rB: 18 {EDX}),
	{[1,3]}   (D: 1; rS: 27 {DS}; rB: 19 {EBX}),
	{[1,4]}   (D: 1; rS: 26 {SS}; rB: 21 {EBP}),
	{[1,5]}   (D: 1; rS: 26 {SS}; rB: 20 {ESP}),
	{[1,6]}   (D: 1; rS: 27 {DS}; rB: 22 {ESI}),
	{[1,7]}   (D: 1; rS: 27 {DS}; rB: 23 {EDI})),
	{[2,0]}  ((D: 4; rS: 27 {DS}; rB: 16 {EAX}),
	{[2,1]}   (D: 4; rS: 27 {DS}; rB: 17 {ECX}),
	{[2,2]}   (D: 4; rS: 27 {DS}; rB: 18 {EDX}),
	{[2,3]}   (D: 4; rS: 27 {DS}; rB: 19 {EBX}),
	{[2,4]}   (D: 4; rS: 26 {SS}; rB: 21 {EBP}),
	{[2,5]}   (D: 4; rS: 26 {SS}; rB: 20 {ESP}),
	{[2,6]}   (D: 4; rS: 27 {DS}; rB: 22 {ESI}),
	{[2,7]}   (D: 4; rS: 27 {DS}; rB: 23 {EDI})));


   sxTab :	ARRAY[0..3] OF   {   ss  field indexes this }	{.CP20}
		ARRAY[0..7] OF   { index field indexes this }
			sxRec = (

	{[0,0]} ((rX: 16 {EAX}; sF: 1),  {[0,1]} (rX: 17 {ECX}; sF: 1),
	{[0,2]}  (rX: 18 {EDX}; sF: 1),  {[0,3]} (rX: 19 {EBX}; sF: 1),
	{[0,4]}  (rX: 30 {};    sF: 0),  {[0,5]} (rX: 21 {EBP}; sF: 1),
	{[0,6]}  (rX: 22 {ESI}; sF: 1),  {[0,7]} (rX: 23 {EDI}; sF: 1)),
	{[1,0]} ((rX: 16 {EAX}; sF: 2),  {[1,1]} (rX: 17 {ECX}; sF: 2),
	{[1,2]}  (rX: 18 {EDX}; sF: 2),  {[1,3]} (rX: 19 {EBX}; sF: 2),
	{[1,4]}  (rX: 30 {};    sF: 0),  {[1,5]} (rX: 21 {EBP}; sF: 2),
	{[1,6]}  (rX: 22 {ESI}; sF: 2),  {[1,7]} (rX: 23 {EDI}; sF: 2)),
	{[2,0]} ((rX: 16 {EAX}; sF: 4),  {[2,1]} (rX: 17 {ECX}; sF: 4),
	{[2,2]}  (rX: 18 {EDX}; sF: 4),  {[2,3]} (rX: 19 {EBX}; sF: 4),
	{[2,4]}  (rX: 30 {};    sF: 0),  {[2,5]} (rX: 21 {EBP}; sF: 4),
	{[2,6]}  (rX: 22 {ESI}; sF: 4),  {[2,7]} (rX: 23 {EDI}; sF: 4)),
	{[3,0]} ((rX: 16 {EAX}; sF: 8),  {[3,1]} (rX: 17 {ECX}; sF: 8),
	{[3,2]}  (rX: 18 {EDX}; sF: 8),  {[3,3]} (rX: 19 {EBX}; sF: 8),
	{[3,4]}  (rX: 30 {};    sF: 0),  {[3,5]} (rX: 21 {EBP}; sF: 8),
	{[3,6]}  (rX: 22 {ESI}; sF: 8),  {[3,7]} (rX: 23 {EDI}; sF: 8)));

	{ -------------------------------------------- }	{.CP44}
	{ Control Tables for 80387 Instructions Follow }
	{ -------------------------------------------- }

{ 387 EA table;	1st index = ESC group;
		2nd index = REG field;
}

   MpuEA :	ARRAY[0..7] OF
		ARRAY[0..7] OF MpuVec = (  { used if mod <> 3 }


	{[0,0]} ((F: $18;M: 03),	{[0,1]}  (F: $18;M: 44),
	{[0,2]}  (F: $18;M: 09),	{[0,3]}  (F: $18;M: 10),
	{[0,4]}  (F: $18;M: 64),	{[0,5]}  (F: $18;M: 66),
	{[0,6]}  (F: $18;M: 15),	{[0,7]}  (F: $18;M: 17)),
	{[1,0]} ((F: $18;M: 34),	{[1,1]}  (F: $00;M: 00),
	{[1,2]}  (F: $18;M: 59),	{[1,3]}  (F: $18;M: 62),
	{[1,4]}  (F: $13;M: 37),	{[1,5]}  (F: $14;M: 36),
	{[1,6]}  (F: $13;M: 61),	{[1,7]}  (F: $14;M: 60)),
	{[2,0]} ((F: $15;M: 21),	{[2,1]}  (F: $15;M: 27),
	{[2,2]}  (F: $15;M: 22),	{[2,3]}  (F: $15;M: 23),
	{[2,4]}  (F: $15;M: 32),	{[2,5]}  (F: $15;M: 33),
	{[2,6]}  (F: $15;M: 24),	{[2,7]}  (F: $15;M: 25)),
	{[3,0]} ((F: $15;M: 26),	{[3,1]}  (F: $00;M: 00),
	{[3,2]}  (F: $15;M: 30),	{[3,3]}  (F: $15;M: 31),
	{[3,4]}  (F: $00;M: 00),	{[3,5]}  (F: $1A;M: 34),
	{[3,6]}  (F: $00;M: 00),	{[3,7]}  (F: $1A;M: 62)),
	{[4,0]} ((F: $19;M: 03),	{[4,1]}  (F: $19;M: 44),
	{[4,2]}  (F: $19;M: 09),	{[4,3]}  (F: $19;M: 10),
	{[4,4]}  (F: $19;M: 64),	{[4,5]}  (F: $19;M: 66),
	{[4,6]}  (F: $19;M: 15),	{[4,7]}  (F: $19;M: 17)),
	{[5,0]} ((F: $19;M: 34),	{[5,1]}  (F: $00;M: 00),
	{[5,2]}  (F: $19;M: 59),	{[5,3]}  (F: $19;M: 62),
	{[5,4]}  (F: $13;M: 52),	{[5,5]}  (F: $00;M: 00),
	{[5,6]}  (F: $13;M: 53),	{[5,7]}  (F: $14;M: 63)),
	{[6,0]} ((F: $16;M: 21),	{[6,1]}  (F: $16;M: 27),
	{[6,2]}  (F: $16;M: 22),	{[6,3]}  (F: $16;M: 23),
	{[6,4]}  (F: $16;M: 32),	{[6,5]}  (F: $16;M: 33),
	{[6,6]}  (F: $16;M: 24),	{[6,7]}  (F: $16;M: 25)),
	{[7,0]} ((F: $16;M: 26),	{[7,1]}  (F: $00;M: 00),
	{[7,2]}  (F: $16;M: 30),	{[7,3]}  (F: $16;M: 31),
	{[7,4]}  (F: $12;M: 05),	{[7,5]}  (F: $17;M: 26),
	{[7,6]}  (F: $12;M: 06),	{[7,7]}  (F: $17;M: 31)));


{ 387 mod=3 table part 1; use when mod field = 3 to access flags   }{.CP37}

   MpuM11 :	ARRAY[0..7] OF
		ARRAY[0..7] OF MpuVec = ( {M: is index to MpuOv }

	{[0,0]} ((F: $1D; M: 01),	{[0,1]}  (F: $1D; M: 02),
	{[0,2]}  (F: $1D; M: 03),	{[0,3]}  (F: $1D; M: 04),
	{[0,4]}  (F: $1D; M: 05),	{[0,5]}  (F: $1D; M: 06),
	{[0,6]}  (F: $1D; M: 07),	{[0,7]}  (F: $1D; M: 08)),
	{[1,0]} ((F: $1B; M: 09),	{[1,1]}  (F: $1B; M: 10),
	{[1,2]}  (F: $20; M: 11),	{[1,3]}  (F: $00; M: 00),
	{[1,4]}  (F: $20; M: 12),	{[1,5]}  (F: $20; M: 13),
	{[1,6]}  (F: $20; M: 14),	{[1,7]}  (F: $20; M: 15)),
	{[2,0]} ((F: $00; M: 00),	{[2,1]}  (F: $00; M: 00),
	{[2,2]}  (F: $00; M: 00),	{[2,3]}  (F: $00; M: 00),
	{[2,4]}  (F: $00; M: 00),	{[2,5]}  (F: $20; M: 16),
	{[2,6]}  (F: $00; M: 00),	{[2,7]}  (F: $00; M: 00)),
	{[3,0]} ((F: $00; M: 00),	{[3,1]}  (F: $00; M: 00),
	{[3,2]}  (F: $00; M: 00),	{[3,3]}  (F: $00; M: 00),
	{[3,4]}  (F: $20; M: 17),	{[3,5]}  (F: $00; M: 00),
	{[3,6]}  (F: $00; M: 00),	{[3,7]}  (F: $00; M: 00)),
	{[4,0]} ((F: $1C; M: 18),	{[4,1]}  (F: $1C; M: 19),
	{[4,2]}  (F: $1C; M: 20),	{[4,3]}  (F: $1C; M: 21),
	{[4,4]}  (F: $1C; M: 22),	{[4,5]}  (F: $1C; M: 23),
	{[4,6]}  (F: $1C; M: 24),	{[4,7]}  (F: $1C; M: 25)),
	{[5,0]} ((F: $1B; M: 26),	{[5,1]}  (F: $00; M: 00),
	{[5,2]}  (F: $1B; M: 27),	{[5,3]}  (F: $1B; M: 28),
	{[5,4]}  (F: $1B; M: 29),	{[5,5]}  (F: $1B; M: 30),
	{[5,6]}  (F: $00; M: 00),	{[5,7]}  (F: $00; M: 00)),
	{[6,0]} ((F: $1C; M: 31),	{[6,1]}  (F: $1C; M: 32),
	{[6,2]}  (F: $00; M: 00),	{[6,3]}  (F: $20; M: 33),
	{[6,4]}  (F: $1C; M: 34),	{[6,5]}  (F: $1C; M: 35),
	{[6,6]}  (F: $1C; M: 36),	{[6,7]}  (F: $1C; M: 37)),
	{[7,0]} ((F: $00; M: 00),	{[7,1]}  (F: $00; M: 00),
	{[7,2]}  (F: $00; M: 00),	{[7,3]}  (F: $00; M: 00),
	{[7,4]}  (F: $21; M: 38),	{[7,5]}  (F: $00; M: 00),
	{[7,6]}  (F: $00; M: 00),	{[7,7]}  (F: $00; M: 00)));

{ 387 mod=3 table part 2; use when mod field = 3 to find mnemonic  }{.CP46}

   MpuOv :	ARRAY[01..38] OF
		ARRAY[00..07] OF Byte = (

	{			       R/M Values
				(00,01,02,03,04,05,06,07)
	esc,reg			 -- -- -- -- -- -- -- --		}
	{[0,0]-->link[01]}	(03,03,03,03,03,03,03,03), {FADD}
	{[0,1]-->link[02]}	(44,44,44,44,44,44,44,44), {FMUL}
	{[0,2]-->link[03]}	(09,09,09,09,09,09,09,09), {FCOM}
	{[0,3]-->link[04]}	(10,10,10,10,10,10,10,10), {FCOMP}
	{[0,4]-->link[05]}	(64,64,64,64,64,64,64,64), {FSUB}
	{[0,5]-->link[06]}	(66,66,66,66,66,66,66,66), {FSUBR}
	{[0,6]-->link[07]}	(15,15,15,15,15,15,15,15), {FDIV}
	{[0,7]-->link[08]}	(17,17,17,17,17,17,17,17), {FDIVR}
	{[1,0]-->link[09]}	(34,34,34,34,34,34,34,34), {FLD}
	{[1,1]-->link[10]}	(73,73,73,73,73,73,73,73), {FXCH}
	{[1,2]-->link[11]}	(46,00,00,00,00,00,00,00), {FNOP,err..}
	{[1,4]-->link[12]}	(07,02,00,00,68,72,00,00), {FCHS..FXAM}
	{[1,5]-->link[13]}	(35,40,39,42,38,41,43,00), {FLD1..FLDZ}
	{[1,6]-->link[14]}	(01,75,50,47,74,49,13,28), {F2XM1..FINCSTP}
	{[1,7]-->link[15]}	(48,76,58,57,51,54,56,12), {FPREM..FCOS}
	{[2,5]-->link[16]}	(00,71,00,00,00,00,00,00), {FUCOMPP}
	{[3,4]-->link[17]}	(19,14,08,29,55,00,00,00), {FENI..FSETPM}
	{[4,0]-->link[18]}	(03,03,03,03,03,03,03,03), {FADD}
	{[4,1]-->link[19]}	(44,44,44,44,44,44,44,44), {FMUL}
	{[4,2]-->link[20]}	(09,09,09,09,09,09,09,09), {FCOM}
	{[4,3]-->link[21]}	(10,10,10,10,10,10,10,10), {FCOMP}
	{[4,4]-->link[22]}	(64,64,64,64,64,64,64,64), {FSUB}
	{[4,5]-->link[23]}	(66,66,66,66,66,66,66,66), {FSUBR}
	{[4,6]-->link[24]}	(15,15,15,15,15,15,15,15), {FDIV}
	{[4,7]-->link[25]}	(17,17,17,17,17,17,17,17), {FDIVR}
	{[5,0]-->link[26]}	(20,20,20,20,20,20,20,20), {FFREE}
	{[5,2]-->link[27]}	(59,59,59,59,59,59,59,59), {FST}
	{[5,3]-->link[28]}	(62,62,62,62,62,62,62,62), {FSTP}
	{[5,4]-->link[29]}	(69,69,69,69,69,69,69,69), {FUCOM}
	{[5,5]-->link[30]}	(70,70,70,70,70,70,70,70), {FUCOMP}
	{[6,0]-->link[31]}	(04,04,04,04,04,04,04,04), {FADDP}
	{[6,1]-->link[32]}	(45,45,45,45,45,45,45,45), {FMULP}
	{[6,3]-->link[33]}	(00,11,00,00,00,00,00,00), {FCOMPP}
	{[6,4]-->link[34]}	(65,65,65,65,65,65,65,65), {FSUBP}
	{[6,5]-->link[35]}	(67,67,67,67,67,67,67,67), {FSUBRP}
	{[6,6]-->link[36]}	(16,16,16,16,16,16,16,16), {FDIVP}
	{[6,7]-->link[37]}	(18,18,18,18,18,18,18,18), {FDIVRP}
	{[7,4]-->link[38]}	(63,00,00,00,00,00,00,00));{FSTSW}
